/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.core.ui.intellij.views.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.JBTable;
import com.jetbrains.JBRFileDialog;
import de.setsoftware.reviewtool.config.ConfigurationInterpreter;
import de.setsoftware.reviewtool.core.ui.intellij.config.CortCredentialManager;
import de.setsoftware.reviewtool.core.ui.intellij.config.ProjectSettings;
import de.setsoftware.reviewtool.core.ui.intellij.plugin.ReviewPlugin;
import de.setsoftware.reviewtool.core.ui.intellij.views.config.UserConfigPasswordCellRenderer;
import de.setsoftware.reviewtool.core.ui.intellij.views.config.UserValueConfigTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdesktop.swingx.VerticalLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0001H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0001H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0001H\u0002J\u0012\u0010\u001c\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/views/config/CortConfigPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "configFileLocationTextField", "Lcom/intellij/ui/components/JBTextField;", "browserConfigFileLocationButton", "Ljavax/swing/JButton;", "tableModel", "Lde/setsoftware/reviewtool/core/ui/intellij/views/config/UserValueConfigTableModel;", "configTable", "Lcom/intellij/ui/table/JBTable;", "credentialManager", "Lde/setsoftware/reviewtool/core/ui/intellij/config/CortCredentialManager;", "reviewPlugin", "Lde/setsoftware/reviewtool/core/ui/intellij/plugin/ReviewPlugin;", "isModified", "", "()Z", "setModified", "(Z)V", "buildConfigPage", "initFileChooser", "", "jPanel", "initTable", "populateTableFromConfigFile", "configFileLocation", "", "setSettings", "settings", "Lde/setsoftware/reviewtool/core/ui/intellij/config/ProjectSettings;", "createSettings", "Companion", "IntelliJ-CoRT"})
public final class CortConfigPanel
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JBTextField configFileLocationTextField;
    @NotNull
    private final JButton browserConfigFileLocationButton;
    @NotNull
    private final UserValueConfigTableModel tableModel;
    @NotNull
    private final JBTable configTable;
    @NotNull
    private final CortCredentialManager credentialManager;
    @NotNull
    private final ReviewPlugin reviewPlugin;
    private boolean isModified;
    @NotNull
    private static final Logger LOG;

    public CortConfigPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(new BorderLayout());
        this.project = project;
        this.configFileLocationTextField = new JBTextField();
        this.browserConfigFileLocationButton = new JButton("browse");
        this.tableModel = new UserValueConfigTableModel();
        this.configTable = new JBTable((TableModel)this.tableModel);
        this.credentialManager = CortCredentialManager.Companion.getInstance(this.project);
        this.reviewPlugin = ReviewPlugin.Companion.getInstance(this.project);
        this.add(this.buildConfigPage());
    }

    public final boolean isModified() {
        return this.isModified;
    }

    public final void setModified(boolean bl) {
        this.isModified = bl;
    }

    private final JPanel buildConfigPage() {
        JPanel jPanel = new JPanel((LayoutManager)new VerticalLayout());
        jPanel.add((Component)new JBLabel("Settings for the CoRT code review tool"));
        this.initFileChooser(jPanel);
        this.initTable(jPanel);
        return jPanel;
    }

    private final void initFileChooser(JPanel jPanel) {
        this.configFileLocationTextField.addFocusListener((FocusListener)new FocusAdapter(this){
            final /* synthetic */ CortConfigPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CortConfigPanel.access$populateTableFromConfigFile(this.this$0, CortConfigPanel.access$getConfigFileLocationTextField$p(this.this$0).getText());
                this.this$0.setModified(true);
            }
        });
        this.browserConfigFileLocationButton.addActionListener(arg_0 -> CortConfigPanel.initFileChooser$lambda$0(this, arg_0));
        JPanel configFilePanel = new JPanel(new BorderLayout());
        configFilePanel.add((Component)new JBLabel("File with team config"), "West");
        configFilePanel.add((Component)this.configFileLocationTextField, "Center");
        configFilePanel.add((Component)this.browserConfigFileLocationButton, "East");
        jPanel.add(configFilePanel);
    }

    private final void initTable(JPanel jPanel) {
        this.configTable.setAutoResizeMode(3);
        this.configTable.setStriped(true);
        this.configTable.getTableHeader().setReorderingAllowed(false);
        this.configTable.getColumnModel().getColumn(1).setCellRenderer(new UserConfigPasswordCellRenderer());
        this.tableModel.addTableModelListener(arg_0 -> CortConfigPanel.initTable$lambda$1(this, arg_0));
        jPanel.add((Component)this.configTable.getTableHeader(), "North");
        jPanel.add((Component)this.configTable);
    }

    private final void populateTableFromConfigFile(String configFileLocation) {
        Object object;
        Object $this$populateTableFromConfigFile_u24lambda_u242;
        CharSequence charSequence = configFileLocation;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        Object object2 = this;
        try {
            $this$populateTableFromConfigFile_u24lambda_u242 = object2;
            boolean bl = false;
            $this$populateTableFromConfigFile_u24lambda_u242 = Result.constructor-impl((Object)new ConfigurationInterpreter().getUserSpecificParamNames(ConfigurationInterpreter.load((String)configFileLocation)));
        }
        catch (Throwable bl) {
            $this$populateTableFromConfigFile_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$populateTableFromConfigFile_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            LOG.error("Error configuring CoRT.", it);
            object = SetsKt.emptySet();
        }
        Set config = (Set)object;
        this.tableModel.handleConfigKeys(config, this.credentialManager);
    }

    public final void setSettings(@NotNull ProjectSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.configFileLocationTextField.setText(settings.getConfigFileLocation());
        this.populateTableFromConfigFile(settings.getConfigFileLocation());
    }

    @NotNull
    public final ProjectSettings createSettings() {
        ProjectSettings ret = ProjectSettings.Companion.create();
        ret.setConfigFileLocation(this.configFileLocationTextField.getText());
        this.tableModel.storeUserValues(this.credentialManager);
        return ret;
    }

    private static final void initFileChooser$lambda$0(CortConfigPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String[] stringArray = new String[]{"xml"};
        FileChooserDescriptor descriptor = (FileChooserDescriptor)new FileTypeDescriptor("choose file with CoRT team config", stringArray);
        VirtualFile chosen = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this$0.project, (VirtualFile)ProjectUtil.guessProjectDir((Project)this$0.project));
        if (chosen != null) {
            this$0.isModified = true;
            String configFile = VfsUtilCore.virtualToIoFile((VirtualFile)chosen).getAbsolutePath();
            this$0.configFileLocationTextField.setText(configFile);
            this$0.populateTableFromConfigFile(configFile);
        }
        JBRFileDialog.get((FileDialog)new FileDialog(new Frame()));
    }

    private static final void initTable$lambda$1(CortConfigPanel this$0, TableModelEvent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getType() == 0 && e.getColumn() == 1) {
            this$0.isModified = true;
        }
    }

    public static final /* synthetic */ void access$populateTableFromConfigFile(CortConfigPanel $this, String configFileLocation) {
        $this.populateTableFromConfigFile(configFileLocation);
    }

    public static final /* synthetic */ JBTextField access$getConfigFileLocationTextField$p(CortConfigPanel $this) {
        return $this.configFileLocationTextField;
    }

    static {
        Logger logger = Logger.getInstance(CortConfigPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/views/config/CortConfigPanel$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "IntelliJ-CoRT"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

