/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.core.ui.intellij;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.panels.VerticalBox;
import de.setsoftware.reviewtool.core.ui.intellij.plugin.ReviewPlugin;
import de.setsoftware.reviewtool.model.ITicketConnector;
import de.setsoftware.reviewtool.model.TicketInfo;
import de.setsoftware.reviewtool.ticketconnectors.jira.JiraPersistence;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u0010J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\u0006\u0010\u001b\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001c\u001a\u00020\u001d*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/TicketDetailAndActionsView;", "Lcom/intellij/ui/components/panels/VerticalBox;", "project", "Lcom/intellij/openapi/project/Project;", "forReview", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "getForReview", "()Z", "stateField", "Ljavax/swing/JTextField;", "prevStateField", "prevReviewersField", "openForDaysField", "currentTicket", "Lde/setsoftware/reviewtool/model/TicketInfo;", "openInJiraButton", "Ljavax/swing/JButton;", "reviewStartInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "startReviewOrFixing", "", "openInJira", "update", "ticketInfo", "resetFields", "configChanged", "safeLinkSettingsText", "", "Lde/setsoftware/reviewtool/model/ITicketConnector;", "getSafeLinkSettingsText", "(Lde/setsoftware/reviewtool/model/ITicketConnector;)Ljava/lang/String;", "Companion", "IntelliJ-CoRT"})
@SourceDebugExtension(value={"SMAP\nTicketDetailAndActionsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TicketDetailAndActionsView.kt\nde/setsoftware/reviewtool/core/ui/intellij/TicketDetailAndActionsView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class TicketDetailAndActionsView
extends VerticalBox {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final boolean forReview;
    @NotNull
    private final JTextField stateField;
    @NotNull
    private final JTextField prevStateField;
    @NotNull
    private final JTextField prevReviewersField;
    @NotNull
    private final JTextField openForDaysField;
    @Nullable
    private TicketInfo currentTicket;
    @NotNull
    private final JButton openInJiraButton;
    @NotNull
    private final AtomicBoolean reviewStartInProgress;

    public TicketDetailAndActionsView(@NotNull Project project, boolean forReview) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.forReview = forReview;
        JPanel detailsPanel = new JPanel(new GridLayout(0, 4));
        detailsPanel.add(new JLabel("State: ", 4));
        Component component = detailsPanel.add(TicketDetailAndActionsView.Companion.createNonEditableTextField());
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JTextField");
        this.stateField = (JTextField)component;
        detailsPanel.add(new JLabel("prev. State: ", 4));
        Component component2 = detailsPanel.add(TicketDetailAndActionsView.Companion.createNonEditableTextField());
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JTextField");
        this.prevStateField = (JTextField)component2;
        detailsPanel.add(new JLabel("prev. Reviewers: ", 4));
        Component component3 = detailsPanel.add(TicketDetailAndActionsView.Companion.createNonEditableTextField());
        Intrinsics.checkNotNull((Object)component3, (String)"null cannot be cast to non-null type javax.swing.JTextField");
        this.prevReviewersField = (JTextField)component3;
        detailsPanel.add(new JLabel("Open for: ", 4));
        Component component4 = detailsPanel.add(TicketDetailAndActionsView.Companion.createNonEditableTextField());
        Intrinsics.checkNotNull((Object)component4, (String)"null cannot be cast to non-null type javax.swing.JTextField");
        this.openForDaysField = (JTextField)component4;
        this.add(detailsPanel);
        Box buttonBox = VerticalBox.createHorizontalBox();
        ITicketConnector ticketConnector = ReviewPlugin.Companion.getInstance(this.project).getTicketConnector();
        this.openInJiraButton = new JButton(this.getSafeLinkSettingsText(ticketConnector));
        this.openInJiraButton.addActionListener(arg_0 -> TicketDetailAndActionsView._init_$lambda$0(this, arg_0));
        this.openInJiraButton.setEnabled(ticketConnector instanceof JiraPersistence);
        buttonBox.add(this.openInJiraButton);
        JButton startReviewButton = new JButton(this.forReview ? "Start Review" : "Start Fixing");
        startReviewButton.addActionListener(arg_0 -> TicketDetailAndActionsView._init_$lambda$1(this, arg_0));
        buttonBox.add(startReviewButton);
        this.add(buttonBox);
        this.reviewStartInProgress = new AtomicBoolean(false);
    }

    public final boolean getForReview() {
        return this.forReview;
    }

    public final synchronized void startReviewOrFixing() {
        if (this.reviewStartInProgress.get()) {
            return;
        }
        this.reviewStartInProgress.set(true);
        Project project = this.project;
        Task.Backgroundable task2 = new Task.Backgroundable(this, project){
            final /* synthetic */ TicketDetailAndActionsView this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, "starting Review");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    Project project = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    TicketInfo ticketInfo = TicketDetailAndActionsView.access$getCurrentTicket$p(this.this$0);
                    ReviewPlugin.Companion.getInstance(project).startReviewOrFixingWithTicket(ticketInfo != null ? ticketInfo.getId() : null, this.this$0.getForReview());
                }
                finally {
                    TicketDetailAndActionsView.access$getReviewStartInProgress$p(this.this$0).set(false);
                }
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    private final void openInJira() {
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                TicketInfo ticketInfo = this.currentTicket;
                desktop.browse(URI.create(ReviewPlugin.Companion.getInstance(this.project).getPersistence().getTicketLinkSettings().createLinkFor(ticketInfo != null ? ticketInfo.getId() : null)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public final void update(@Nullable TicketInfo ticketInfo) {
        this.currentTicket = ticketInfo;
        if (ticketInfo == null) {
            this.resetFields();
            return;
        }
        this.stateField.setText(ticketInfo.getState());
        this.prevStateField.setText(ticketInfo.getPreviousState());
        this.prevReviewersField.setText(String.join((CharSequence)", ", ticketInfo.getReviewers()));
        String string = "%d days";
        Object[] objectArray = new Object[]{ticketInfo.getWaitingForDays(Date.from(Instant.now()))};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        this.openForDaysField.setText(string2);
    }

    private final void resetFields() {
        this.stateField.setText("");
        this.prevStateField.setText("");
        this.prevReviewersField.setText("");
        this.openForDaysField.setText("");
    }

    public final void configChanged() {
        ITicketConnector ticketConnector = ReviewPlugin.Companion.getInstance(this.project).getTicketConnector();
        this.openInJiraButton.setEnabled(ticketConnector instanceof JiraPersistence);
        this.openInJiraButton.setText(this.getSafeLinkSettingsText(ticketConnector));
    }

    private final String getSafeLinkSettingsText(ITicketConnector $this$safeLinkSettingsText) {
        Object object;
        Object object2 = $this$safeLinkSettingsText;
        try {
            ITicketConnector $this$_get_safeLinkSettingsText__u24lambda_u242 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$_get_safeLinkSettingsText__u24lambda_u242.getLinkSettings().getText());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = "Please configure CoRT";
        return (String)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    private static final void _init_$lambda$0(TicketDetailAndActionsView this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.openInJira();
    }

    private static final void _init_$lambda$1(TicketDetailAndActionsView this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.startReviewOrFixing();
    }

    public static final /* synthetic */ TicketInfo access$getCurrentTicket$p(TicketDetailAndActionsView $this) {
        return $this.currentTicket;
    }

    public static final /* synthetic */ AtomicBoolean access$getReviewStartInProgress$p(TicketDetailAndActionsView $this) {
        return $this.reviewStartInProgress;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/TicketDetailAndActionsView$Companion;", "", "<init>", "()V", "createNonEditableTextField", "Ljavax/swing/JTextField;", "IntelliJ-CoRT"})
    public static final class Companion {
        private Companion() {
        }

        private final JTextField createNonEditableTextField() {
            JTextField jTextField = new JTextField();
            jTextField.setEditable(false);
            return jTextField;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

