/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.core.ui.intellij;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.base.WeakListeners;
import de.setsoftware.reviewtool.core.ui.intellij.IntelliJChangeManager;
import de.setsoftware.reviewtool.core.ui.intellij.plugin.ReviewPlugin;
import de.setsoftware.reviewtool.model.api.ChangeSourceException;
import de.setsoftware.reviewtool.model.api.IChangeSource;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u0000 ,2\u00020\u0001:\u0003*+,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u000eJ \u0010$\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u000b2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0017H\u0002J\b\u0010&\u001a\u00020\u001eH\u0002J\b\u0010'\u001a\u00020\u001eH\u0002J\u0006\u0010(\u001a\u00020\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00178F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u0011\u0010)\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010!\u00a8\u0006-"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/IntelliJChangeManager;", "", "reviewPlugin", "Lde/setsoftware/reviewtool/core/ui/intellij/plugin/ReviewPlugin;", "<init>", "(Lde/setsoftware/reviewtool/core/ui/intellij/plugin/ReviewPlugin;)V", "projectDirs", "", "Ljava/io/File;", "changeSourceRef", "", "Lde/setsoftware/reviewtool/model/api/IChangeSource;", "changeManagerListeners", "Lde/setsoftware/reviewtool/base/WeakListeners;", "Ljava/lang/Runnable;", "lastChangeTime", "Ljava/util/concurrent/atomic/AtomicLong;", "workQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lde/setsoftware/reviewtool/core/ui/intellij/IntelliJChangeManager$LocalChangeWorkItem;", "changeTrackingEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "changeSource", "", "changeSources", "getChangeSources", "()Ljava/util/List;", "setChangeSources", "(Ljava/util/List;)V", "disableChangeTracking", "", "isTrackingEnabled", "", "()Z", "addListener", "changeManagerListener", "analyzeLocalChangesAsync", "filesToAnalyze", "addProjectsAndCollectLocalChanges", "processLocalChanges", "clearChangeSourceCaches", "isConfigured", "MutexRule", "LocalChangeWorkItem", "Companion", "IntelliJ-CoRT"})
@SourceDebugExtension(value={"SMAP\nIntelliJChangeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJChangeManager.kt\nde/setsoftware/reviewtool/core/ui/intellij/IntelliJChangeManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
public final class IntelliJChangeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReviewPlugin reviewPlugin;
    @NotNull
    private final Set<File> projectDirs;
    @NotNull
    private final List<IChangeSource> changeSourceRef;
    @NotNull
    private final WeakListeners<Runnable> changeManagerListeners;
    @NotNull
    private final AtomicLong lastChangeTime;
    @NotNull
    private final ConcurrentLinkedQueue<LocalChangeWorkItem> workQueue;
    @NotNull
    private final AtomicBoolean changeTrackingEnabled;
    private static final long PROCESSING_DELAY = 10000L;
    @Nullable
    private static final IntelliJChangeManager INSTANCE;

    public IntelliJChangeManager(@NotNull ReviewPlugin reviewPlugin) {
        Intrinsics.checkNotNullParameter((Object)reviewPlugin, (String)"reviewPlugin");
        this.reviewPlugin = reviewPlugin;
        this.changeManagerListeners = new WeakListeners();
        this.lastChangeTime = new AtomicLong();
        this.workQueue = new ConcurrentLinkedQueue();
        this.changeTrackingEnabled = new AtomicBoolean(true);
        this.projectDirs = new LinkedHashSet();
        this.changeSourceRef = new CopyOnWriteArrayList();
        String basePath = this.reviewPlugin.getProject().getBasePath();
        if (basePath == null) {
            Logger.warn((String)"basePath is unexpectedly null.", null);
        } else {
            ((LinkedHashSet)this.projectDirs).add(new File(basePath));
        }
    }

    @NotNull
    public final List<IChangeSource> getChangeSources() {
        return this.changeSourceRef;
    }

    public final void setChangeSources(@NotNull List<? extends IChangeSource> changeSource) {
        Intrinsics.checkNotNullParameter(changeSource, (String)"changeSource");
        this.changeSourceRef.clear();
        this.changeSourceRef.addAll((Collection<IChangeSource>)changeSource);
        this.addProjectsAndCollectLocalChanges();
    }

    public final void disableChangeTracking() {
        this.changeTrackingEnabled.set(false);
        this.workQueue.clear();
    }

    public final boolean isTrackingEnabled() {
        return this.changeTrackingEnabled.get();
    }

    public final synchronized void addListener(@NotNull Runnable changeManagerListener) {
        Intrinsics.checkNotNullParameter((Object)changeManagerListener, (String)"changeManagerListener");
        this.changeManagerListeners.add((Object)changeManagerListener);
    }

    private final void analyzeLocalChangesAsync(IChangeSource changeSource, List<? extends File> filesToAnalyze) {
        Project project = this.reviewPlugin.getProject();
        Task.Backgroundable task2 = new Task.Backgroundable(changeSource, filesToAnalyze, this, project){
            final /* synthetic */ IChangeSource $changeSource;
            final /* synthetic */ List<File> $filesToAnalyze;
            final /* synthetic */ IntelliJChangeManager this$0;
            {
                this.$changeSource = $changeSource;
                this.$filesToAnalyze = $filesToAnalyze;
                this.this$0 = $receiver;
                super($super_call_param$1, "Analyze changesources CoRT");
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    this.$changeSource.analyzeLocalChanges(this.$filesToAnalyze);
                    IntelliJChangeManager.access$getChangeManagerListeners$p(this.this$0).notifyListeners(analyzeLocalChangesAsync.task.1::run$lambda$0);
                }
                catch (ChangeSourceException e) {
                    Logger.warn((String)"Problem while collecting local changes", (Throwable)e);
                }
            }

            private static final void run$lambda$0(Runnable listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                listener.run();
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    private final synchronized void addProjectsAndCollectLocalChanges() {
        block2: for (File projectRoot : this.projectDirs) {
            for (IChangeSource changeSource : this.changeSourceRef) {
                try {
                    boolean handled = changeSource.addProject(projectRoot);
                    if (!handled) continue;
                    continue block2;
                }
                catch (ChangeSourceException e) {
                    Logger.warn((String)"Problem while adding project to change source", (Throwable)e);
                }
            }
        }
        for (IChangeSource changeSource : this.changeSourceRef) {
            this.analyzeLocalChangesAsync(changeSource, null);
        }
    }

    private final synchronized void processLocalChanges() {
        if (!this.changeTrackingEnabled.get()) {
            return;
        }
        if (this.lastChangeTime.get() + 10000L > System.currentTimeMillis()) {
            return;
        }
        LocalChangeWorkItem workItem = null;
        block2: while (true) {
            Iterator<File> iterator = this.workQueue.poll();
            LocalChangeWorkItem it = iterator;
            boolean bl = false;
            workItem = it;
            if (iterator == null) break;
            try {
                block3: for (File project : workItem.getProjectsAdded()) {
                    for (IChangeSource changeSource : this.changeSourceRef) {
                        this.projectDirs.add(project);
                        boolean handled = changeSource.addProject(project);
                        Logger.info((String)("Adding project " + project));
                        if (!handled) continue;
                        continue block3;
                    }
                }
                for (File project : workItem.getProjectsRemoved()) {
                    for (IChangeSource changeSource : this.changeSourceRef) {
                        this.projectDirs.remove(project);
                        changeSource.removeProject(project);
                        Logger.info((String)("Removing project " + project));
                    }
                }
                iterator = this.changeSourceRef.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    IChangeSource changeSource = (IChangeSource)iterator.next();
                    this.analyzeLocalChangesAsync(changeSource, workItem.getFilesChanged());
                }
            }
            catch (ChangeSourceException e) {
                Logger.warn((String)"Problem while processing local changes incrementally", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public final void clearChangeSourceCaches() {
        for (IChangeSource src : this.changeSourceRef) {
            src.clearCaches();
        }
    }

    public final boolean isConfigured() {
        return !((Collection)this.changeSourceRef).isEmpty();
    }

    public static final /* synthetic */ WeakListeners access$getChangeManagerListeners$p(IntelliJChangeManager $this) {
        return $this.changeManagerListeners;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/IntelliJChangeManager$Companion;", "", "<init>", "()V", "PROCESSING_DELAY", "", "INSTANCE", "Lde/setsoftware/reviewtool/core/ui/intellij/IntelliJChangeManager;", "IntelliJ-CoRT"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/IntelliJChangeManager$LocalChangeWorkItem;", "", "projectsAdded", "", "Ljava/io/File;", "projectsRemoved", "filesChanged", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getProjectsAdded", "()Ljava/util/List;", "getProjectsRemoved", "getFilesChanged", "IntelliJ-CoRT"})
    private static final class LocalChangeWorkItem {
        @NotNull
        private final List<File> projectsAdded;
        @NotNull
        private final List<File> projectsRemoved;
        @NotNull
        private final List<File> filesChanged;

        public LocalChangeWorkItem(@NotNull List<? extends File> projectsAdded, @NotNull List<? extends File> projectsRemoved, @NotNull List<? extends File> filesChanged) {
            Intrinsics.checkNotNullParameter(projectsAdded, (String)"projectsAdded");
            Intrinsics.checkNotNullParameter(projectsRemoved, (String)"projectsRemoved");
            Intrinsics.checkNotNullParameter(filesChanged, (String)"filesChanged");
            this.projectsAdded = projectsAdded;
            this.projectsRemoved = projectsRemoved;
            this.filesChanged = filesChanged;
        }

        @NotNull
        public final List<File> getProjectsAdded() {
            return this.projectsAdded;
        }

        @NotNull
        public final List<File> getProjectsRemoved() {
            return this.projectsRemoved;
        }

        @NotNull
        public final List<File> getFilesChanged() {
            return this.filesChanged;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0016J\u0011\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0096\u0002\u00a8\u0006\t"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/IntelliJChangeManager$MutexRule;", "Lorg/eclipse/core/runtime/jobs/ISchedulingRule;", "<init>", "()V", "isConflicting", "", "rule", "contains", "Companion", "IntelliJ-CoRT"})
    private static final class MutexRule
    implements ISchedulingRule {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final MutexRule instance = new MutexRule();

        private MutexRule() {
        }

        public boolean isConflicting(@NotNull ISchedulingRule rule) {
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            return rule == this;
        }

        public boolean contains(@NotNull ISchedulingRule rule) {
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            return rule == this;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/IntelliJChangeManager$MutexRule$Companion;", "", "<init>", "()V", "instance", "Lde/setsoftware/reviewtool/core/ui/intellij/IntelliJChangeManager$MutexRule;", "getInstance", "()Lde/setsoftware/reviewtool/core/ui/intellij/IntelliJChangeManager$MutexRule;", "IntelliJ-CoRT"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MutexRule getInstance() {
                return instance;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

