/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering.efficientalgorithm;

import de.setsoftware.reviewtool.ordering.efficientalgorithm.CountingSet;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.MatchSet;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.SimpleSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SubsettingSet<S>
implements SimpleSet<S> {
    private final List<MatchSet<S>> potentialFolds;
    private final Set<Integer> remainingFoldIndices;
    private final CountingSet<S> allItems;
    private final CountingSet<S> removedItems;
    private Integer currentCandidate;

    public SubsettingSet(MatchSet<S> toMatch, List<MatchSet<S>> potentialFolds) {
        this.potentialFolds = new ArrayList<MatchSet<S>>(potentialFolds);
        this.remainingFoldIndices = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2 - o1;
            }
        });
        int i = 0;
        while (i < potentialFolds.size()) {
            this.remainingFoldIndices.add(i);
            ++i;
        }
        this.allItems = new CountingSet(toMatch.getChangeParts().size() + potentialFolds.size() * 4);
        this.allItems.addAll(toMatch.getChangeParts());
        for (MatchSet<S> ms : potentialFolds) {
            this.allItems.addAll(ms.getChangeParts());
        }
        this.removedItems = new CountingSet();
    }

    @Override
    public boolean contains(S item) {
        int addCount = this.allItems.get(item);
        int removeCount = this.removedItems.get(item);
        if (this.currentCandidate != null && this.getCurrentCandidate().getChangeParts().contains(item)) {
            ++removeCount;
        }
        return addCount > removeCount;
    }

    @Override
    public Set<S> toSet() {
        LinkedHashSet<S> ret = new LinkedHashSet<S>();
        for (S item : this.allItems.keys()) {
            if (!this.contains(item)) continue;
            ret.add(item);
        }
        return ret;
    }

    private MatchSet<S> getCurrentCandidate() {
        return this.potentialFolds.get(this.currentCandidate);
    }

    public Collection<Integer> potentialRemovals() {
        assert (this.currentCandidate == null);
        return new ArrayList<Integer>(this.remainingFoldIndices);
    }

    public void preliminaryRemove(Integer foldKey) {
        assert (this.currentCandidate == null);
        this.currentCandidate = foldKey;
    }

    public void commitRemoval() {
        this.removedItems.addAll(this.getCurrentCandidate().getChangeParts());
        this.remainingFoldIndices.remove(this.currentCandidate);
        this.currentCandidate = null;
    }

    public void rollbackRemoval() {
        this.currentCandidate = null;
    }
}

