/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering.efficientalgorithm;

import de.setsoftware.reviewtool.ordering.efficientalgorithm.BundleCombination;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.BundleCombinationTreeLeaf;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.BundleCombinationTreeNode;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.ReverseImpossibleException;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.SimpleSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class BundleCombinationTreeElement<T>
implements BundleCombination<T> {
    public static <S> BundleCombinationTreeElement<S> create(Collection<S> asList) {
        assert (asList.size() > 0);
        if (asList.size() == 1) {
            return new BundleCombinationTreeLeaf<S>(asList.iterator().next());
        }
        BundleCombinationTreeElement[] items = new BundleCombinationTreeElement[asList.size()];
        Iterator<S> iter = asList.iterator();
        int i = 0;
        while (iter.hasNext()) {
            items[i] = new BundleCombinationTreeLeaf<S>(iter.next());
            ++i;
        }
        return new BundleCombinationTreeNode(items, true, true);
    }

    @Override
    public final BundleCombinationTreeElement<T> bundle(SimpleSet<T> bundle) {
        BundleResult<T> result;
        block3: {
            try {
                result = this.addBundle(bundle);
                if (((BundleResult)result).resultType != ResultType.CONFLICT) break block3;
                return null;
            }
            catch (ReverseImpossibleException e) {
                return null;
            }
        }
        return ((BundleResult)result).newTree;
    }

    protected abstract BundleResult<T> addBundle(SimpleSet<T> var1);

    public BundleCombinationTreeElement<T> bundleOrdered(SimpleSet<T> center, SimpleSet<T> rest) {
        BundleCombination t1 = this.bundle((SimpleSet)center);
        if (t1 == null) {
            return null;
        }
        BundleCombination t2 = ((BundleCombinationTreeElement)t1).bundle((SimpleSet)rest);
        if (t2 == null) {
            return null;
        }
        return ((BundleCombinationTreeElement)t2).fixOrder(center, rest);
    }

    protected abstract BundleCombinationTreeElement<T> fixOrder(SimpleSet<T> var1, SimpleSet<T> var2);

    protected abstract List<? extends BundleCombinationTreeElement<T>> split(SimpleSet<T> var1);

    protected abstract ResultType checkContainment(SimpleSet<T> var1);

    protected abstract BundleCombinationTreeElement<T> reverse();

    public final boolean equals(Object o) {
        if (!(o instanceof BundleCombinationTreeElement)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public final int hashCode() {
        return 42;
    }

    protected static final class BundleResult<S> {
        private final BundleCombinationTreeElement<S> newTree;
        private final ResultType resultType;

        public BundleResult(ResultType resultType, BundleCombinationTreeElement<S> newTree) {
            this.newTree = newTree;
            this.resultType = resultType;
        }

        public ResultType getType() {
            return this.resultType;
        }

        public BundleCombinationTreeElement<S> getTree() {
            return this.newTree;
        }

        public String toString() {
            return (Object)((Object)this.resultType) + " " + this.newTree;
        }
    }

    protected static enum ResultType {
        NONE{

            @Override
            public boolean hasTopMatch() {
                return false;
            }

            @Override
            public boolean hasBottomMatch() {
                return false;
            }

            @Override
            public boolean isPartial() {
                return false;
            }
        }
        ,
        FULL{

            @Override
            public boolean hasTopMatch() {
                return true;
            }

            @Override
            public boolean hasBottomMatch() {
                return true;
            }

            @Override
            public boolean isPartial() {
                return false;
            }
        }
        ,
        PARTIAL_TOP{

            @Override
            public boolean hasTopMatch() {
                return true;
            }

            @Override
            public boolean hasBottomMatch() {
                return false;
            }

            @Override
            public boolean isPartial() {
                return true;
            }
        }
        ,
        PARTIAL_BOTTOM{

            @Override
            public boolean hasTopMatch() {
                return false;
            }

            @Override
            public boolean hasBottomMatch() {
                return true;
            }

            @Override
            public boolean isPartial() {
                return true;
            }
        }
        ,
        PARTIAL_MIDDLE{

            @Override
            public boolean hasTopMatch() {
                return false;
            }

            @Override
            public boolean hasBottomMatch() {
                return false;
            }

            @Override
            public boolean isPartial() {
                return true;
            }
        }
        ,
        CONFLICT{

            @Override
            public boolean hasTopMatch() {
                return false;
            }

            @Override
            public boolean hasBottomMatch() {
                return false;
            }

            @Override
            public boolean isPartial() {
                return false;
            }
        };


        public abstract boolean hasTopMatch();

        public abstract boolean hasBottomMatch();

        public abstract boolean isPartial();
    }
}

