/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.preferredtransitions.basicstrategies;

import de.setsoftware.reviewtool.model.ITicketData;
import de.setsoftware.reviewtool.model.changestructure.Stop;
import de.setsoftware.reviewtool.model.changestructure.Tour;
import de.setsoftware.reviewtool.model.changestructure.ToursInReview;
import de.setsoftware.reviewtool.preferredtransitions.api.IPreferredTransitionStrategy;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class PathRegexAndReviewerCountStrategy
implements IPreferredTransitionStrategy {
    private final Pattern pattern;
    private final String transitionName;
    private final int maxReviewerCount;

    public PathRegexAndReviewerCountStrategy(String regex, String transitionName, int maxReviewerCount) {
        this.pattern = Pattern.compile(regex);
        this.transitionName = transitionName;
        this.maxReviewerCount = maxReviewerCount;
    }

    @Override
    public List<String> determinePreferredTransitions(boolean forOkCase, ITicketData ticketData, ToursInReview toursInReview) {
        if (!forOkCase) {
            return Collections.emptyList();
        }
        if (ticketData.getTicketInfo().getReviewers().size() > this.maxReviewerCount) {
            return Collections.emptyList();
        }
        for (Tour t : toursInReview.getTopmostTours()) {
            for (Stop s : t.getStops()) {
                if (!this.pattern.matcher(s.getMostRecentFile().getPath()).matches()) continue;
                return Collections.singletonList(this.transitionName);
            }
        }
        return Collections.emptyList();
    }
}

