/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering;

import de.setsoftware.reviewtool.base.Multimap;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.ordering.ChangePart;
import de.setsoftware.reviewtool.ordering.HierarchyExplicitness;
import de.setsoftware.reviewtool.ordering.OrderingInfo;
import de.setsoftware.reviewtool.ordering.OrderingInfoImpl;
import de.setsoftware.reviewtool.ordering.RelationMatcher;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.TourCalculatorControl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class InSameSystemTestRelation
implements RelationMatcher {
    private static final String SYSTEMTEST_FOLDER_NAME = "Systemtestfaelle";
    private static final String AUSGABEDATEIEN = "Ausgabedateien.expected";
    private static final String EINGABEDATEIEN = "Eingabedateien";
    private final HierarchyExplicitness explicitness;

    public InSameSystemTestRelation(HierarchyExplicitness explicitness) {
        this.explicitness = explicitness;
    }

    @Override
    public Collection<? extends OrderingInfo> determineMatches(List<ChangePart> changeParts, TourCalculatorControl control) {
        Multimap grouping = new Multimap();
        for (ChangePart c : changeParts) {
            String systemTest = this.determineSystemTestFolder(c.getStops().get(0).getMostRecentFile());
            if (systemTest == null) continue;
            grouping.put((Object)systemTest, (Object)c);
        }
        ArrayList<OrderingInfo> ret = new ArrayList<OrderingInfo>();
        for (Map.Entry e : grouping.entrySet()) {
            ret.add(OrderingInfoImpl.unordered(this.explicitness, (String)e.getKey(), (Collection)e.getValue()));
        }
        return ret;
    }

    private String determineSystemTestFolder(IRevisionedFile file) {
        File dir = new File(file.getPath()).getParentFile();
        if (!this.isSystemTest(dir)) {
            return null;
        }
        File testDir = this.stripOffTestSubdirs(dir);
        return testDir != null ? testDir.toString() : null;
    }

    private boolean isSystemTest(File dir) {
        if (dir == null) {
            return false;
        }
        if (dir.getName().startsWith(SYSTEMTEST_FOLDER_NAME)) {
            return true;
        }
        return this.isSystemTest(dir.getParentFile());
    }

    private File stripOffTestSubdirs(File dir) {
        File cur = dir;
        do {
            if (!this.isTestSubdir(dir.getName())) continue;
            return dir.getParentFile();
        } while ((cur = cur.getParentFile()) != null);
        return dir;
    }

    private boolean isTestSubdir(String name) {
        return name.equals(AUSGABEDATEIEN) || name.equals(EINGABEDATEIEN);
    }
}

