/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering;

import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.base.Multimap;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.ordering.ChangePart;
import de.setsoftware.reviewtool.ordering.HierarchyExplicitness;
import de.setsoftware.reviewtool.ordering.OrderingInfo;
import de.setsoftware.reviewtool.ordering.OrderingInfoImpl;
import de.setsoftware.reviewtool.ordering.RelationMatcher;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.TourCalculatorControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class InSameSourceFolderRelation
implements RelationMatcher {
    private static final String[] SOURCE_FOLDER_NAMES = new String[]{"src", "test", "resources", "testresources"};
    private final HierarchyExplicitness explicitness;

    public InSameSourceFolderRelation(HierarchyExplicitness explicitness) {
        this.explicitness = explicitness;
    }

    @Override
    public Collection<? extends OrderingInfo> determineMatches(List<ChangePart> changeParts, TourCalculatorControl control) {
        Multimap grouping = new Multimap();
        for (ChangePart c : changeParts) {
            Logger.verboseDebug(() -> "change part with " + c.getStops().size() + " stops, e.g. " + c.getStops().get(0));
            IRevisionedFile mostRecentFile = c.getStops().get(0).getMostRecentFile();
            String sourceFolder = this.determineSourceFolder(mostRecentFile);
            Logger.verboseDebug(() -> "source folder for " + mostRecentFile + " is " + sourceFolder);
            if (sourceFolder == null) continue;
            grouping.put((Object)sourceFolder, (Object)c);
        }
        ArrayList<OrderingInfo> ret = new ArrayList<OrderingInfo>();
        for (Map.Entry e : grouping.entrySet()) {
            ret.add(OrderingInfoImpl.unordered(this.explicitness, (String)e.getKey(), (Collection)e.getValue()));
        }
        return ret;
    }

    private String determineSourceFolder(IRevisionedFile file) {
        String path = file.getPath().replace('\\', '/');
        String[] stringArray = SOURCE_FOLDER_NAMES;
        int n = SOURCE_FOLDER_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String sf = stringArray[n2];
            int index = sf.indexOf("/" + sf + "/");
            if (index >= 0) {
                return path.substring(0, index + sf.length() + 2);
            }
            ++n2;
        }
        return null;
    }
}

