/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering;

import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.model.api.IClassification;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.changestructure.Stop;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class ChangePart {
    private final List<Stop> stops;
    private final Set<? extends IClassification> irrelevantCategories;

    public ChangePart(List<Stop> stops, Set<? extends IClassification> irrelevantCategories) {
        this.stops = stops;
        this.irrelevantCategories = irrelevantCategories;
    }

    public List<Stop> getStops() {
        return this.stops;
    }

    public int hashCode() {
        return this.stops.get(0).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChangePart)) {
            return false;
        }
        return ((ChangePart)o).stops.equals(this.stops);
    }

    public String toString() {
        return this.stops.toString();
    }

    public boolean isFullyIrrelevantForReview() {
        for (Stop s : this.stops) {
            if (s.isIrrelevantForReview(this.irrelevantCategories)) continue;
            return false;
        }
        return true;
    }

    public static List<ChangePart> groupToMinimumGranularity(List<Stop> stopsToGroup, Set<? extends IClassification> irrelevantCategories) {
        ArrayList<Stop> sortedStops = new ArrayList<Stop>(stopsToGroup);
        Collections.sort(sortedStops, new Comparator<Stop>(){

            @Override
            public int compare(Stop o1, Stop o2) {
                int cmp = o1.getOriginalMostRecentFile().getPath().compareTo(o2.getOriginalMostRecentFile().getPath());
                if (cmp != 0) {
                    return cmp;
                }
                return Integer.compare(this.getLine(o1), this.getLine(o2));
            }

            private int getLine(Stop o2) {
                IFragment fragment = o2.getOriginalMostRecentFragment();
                return fragment == null ? -1 : fragment.getFrom().getLine();
            }
        });
        ArrayList<Stop> stopsInCurrentFile = new ArrayList<Stop>();
        Object currentFile = null;
        ArrayList<ChangePart> ret = new ArrayList<ChangePart>();
        for (Stop s : sortedStops) {
            if (currentFile == null || !currentFile.equals(s.getOriginalMostRecentFile())) {
                ChangePart.groupStopsInFile(ret, stopsInCurrentFile, irrelevantCategories);
                currentFile = s.getOriginalMostRecentFile();
                stopsInCurrentFile.clear();
            }
            stopsInCurrentFile.add(s);
        }
        ChangePart.groupStopsInFile(ret, stopsInCurrentFile, irrelevantCategories);
        return ret;
    }

    private static void groupStopsInFile(List<ChangePart> resultBuffer, List<Stop> stopsInCurrentFile, Set<? extends IClassification> irrelevantCategories) {
        if (stopsInCurrentFile.isEmpty()) {
            return;
        }
        if (stopsInCurrentFile.size() == 1) {
            resultBuffer.add(new ChangePart(Collections.singletonList(stopsInCurrentFile.get(0)), irrelevantCategories));
            return;
        }
        if (stopsInCurrentFile.get(0).isBinaryChange()) {
            ChangePart.dontGroup(resultBuffer, stopsInCurrentFile, irrelevantCategories);
            return;
        }
        String filename = stopsInCurrentFile.get(0).getOriginalMostRecentFile().getPath().toLowerCase();
        if (filename.endsWith(".java") || filename.endsWith(".jav")) {
            ChangePart.groupForJava(resultBuffer, stopsInCurrentFile, irrelevantCategories);
        } else {
            ChangePart.dontGroup(resultBuffer, stopsInCurrentFile, irrelevantCategories);
        }
    }

    private static void dontGroup(List<ChangePart> resultBuffer, List<Stop> stopsInCurrentFile, Set<? extends IClassification> irrelevantCategories) {
        for (Stop s : stopsInCurrentFile) {
            resultBuffer.add(new ChangePart(Collections.singletonList(s), irrelevantCategories));
        }
    }

    private static void groupForJava(List<ChangePart> resultBuffer, List<Stop> stopsInCurrentFile, Set<? extends IClassification> irrelevantCategories) {
        byte[] contents;
        try {
            contents = stopsInCurrentFile.get(0).getOriginalMostRecentFile().getContents();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (Exception e) {
            throw new ReviewtoolException(e);
        }
        if (contents == null) {
            ChangePart.dontGroup(resultBuffer, stopsInCurrentFile, irrelevantCategories);
            return;
        }
        IslandScanner scanner = new IslandScanner(contents);
        int currentBlockEnd = scanner.getNextRegionEndLineNumber();
        ArrayList<Object> stopsInCurrentBlock = new ArrayList<Stop>();
        for (Stop s : stopsInCurrentFile) {
            int stopStartLine = s.getOriginalMostRecentFragment().getFrom().getLine();
            if (stopStartLine <= currentBlockEnd) {
                stopsInCurrentBlock.add(s);
                continue;
            }
            if (!stopsInCurrentBlock.isEmpty()) {
                resultBuffer.add(new ChangePart(stopsInCurrentBlock, irrelevantCategories));
            }
            while (stopStartLine > (currentBlockEnd = scanner.getNextRegionEndLineNumber())) {
            }
            stopsInCurrentBlock = new ArrayList();
            stopsInCurrentBlock.add(s);
        }
        resultBuffer.add(new ChangePart(stopsInCurrentBlock, irrelevantCategories));
    }

    private static final class IslandScanner {
        private final byte[] content;
        private int pos;
        private IslandScannerState previousEndState;
        private int nestingDepth;
        private int currentLineNumber;

        public IslandScanner(byte[] content) {
            this.content = content;
            this.pos = 0;
            this.previousEndState = IslandScannerState.INIT;
            this.currentLineNumber = 0;
        }

        public int getNextRegionEndLineNumber() {
            while (this.pos < this.content.length) {
                ++this.currentLineNumber;
                boolean hadPotentialEnd = false;
                List<TokenType> tokens = this.parseNextLine();
                for (TokenType token : tokens) {
                    switch (token) {
                        case BRACE_OPEN: {
                            hadPotentialEnd = true;
                            ++this.nestingDepth;
                            break;
                        }
                        case BRACE_CLOSE: {
                            hadPotentialEnd = true;
                            --this.nestingDepth;
                            break;
                        }
                        case SEMI: {
                            hadPotentialEnd = true;
                            break;
                        }
                    }
                }
                if (this.nestingDepth >= 2 || !hadPotentialEnd && !tokens.isEmpty()) continue;
                return this.currentLineNumber;
            }
            return Integer.MAX_VALUE;
        }

        public List<TokenType> parseNextLine() {
            ArrayList<TokenType> ret = new ArrayList<TokenType>();
            IslandScannerState state = this.previousEndState == IslandScannerState.IN_MULTILINE_COMMENT ? IslandScannerState.IN_MULTILINE_COMMENT : IslandScannerState.INIT;
            while (this.pos < this.content.length) {
                byte cur;
                if ((cur = this.content[this.pos++]) == 10) break;
                block0 : switch (state) {
                    case INIT: {
                        switch (cur) {
                            case 47: {
                                state = IslandScannerState.POSSIBLE_COMMENT_START;
                                break block0;
                            }
                            case 34: {
                                state = IslandScannerState.STRING;
                                break block0;
                            }
                            case 39: {
                                state = IslandScannerState.CHAR;
                                break block0;
                            }
                            case 9: 
                            case 13: 
                            case 32: {
                                break block0;
                            }
                            case 123: {
                                ret.add(TokenType.BRACE_OPEN);
                                break block0;
                            }
                            case 125: {
                                ret.add(TokenType.BRACE_CLOSE);
                                break block0;
                            }
                            case 59: {
                                ret.add(TokenType.SEMI);
                                break block0;
                            }
                        }
                        state = IslandScannerState.GENERIC_CONTENT;
                        break;
                    }
                    case GENERIC_CONTENT: {
                        switch (cur) {
                            case 47: {
                                ret.add(TokenType.SEA);
                                state = IslandScannerState.POSSIBLE_COMMENT_START;
                                break block0;
                            }
                            case 34: {
                                state = IslandScannerState.STRING;
                                break block0;
                            }
                            case 39: {
                                state = IslandScannerState.CHAR;
                                break block0;
                            }
                            case 123: {
                                ret.add(TokenType.BRACE_OPEN);
                                break block0;
                            }
                            case 125: {
                                ret.add(TokenType.BRACE_CLOSE);
                                break block0;
                            }
                            case 59: {
                                ret.add(TokenType.SEMI);
                                break block0;
                            }
                        }
                        break;
                    }
                    case POSSIBLE_COMMENT_START: {
                        switch (cur) {
                            case 42: {
                                ret.add(TokenType.MULTILINE_COMMENT_START);
                                state = IslandScannerState.IN_MULTILINE_COMMENT;
                                break block0;
                            }
                            case 47: {
                                ret.add(TokenType.SINGLE_LINE_COMMENT);
                                state = IslandScannerState.IN_SINGLELINE_COMMENT;
                                break block0;
                            }
                        }
                        state = IslandScannerState.GENERIC_CONTENT;
                        break;
                    }
                    case IN_SINGLELINE_COMMENT: {
                        break;
                    }
                    case IN_MULTILINE_COMMENT: {
                        switch (cur) {
                            case 42: {
                                state = IslandScannerState.POSSIBLE_COMMENT_END;
                                break block0;
                            }
                        }
                        break;
                    }
                    case POSSIBLE_COMMENT_END: {
                        switch (cur) {
                            case 47: {
                                ret.add(TokenType.MULTILINE_COMMENT_END);
                                state = IslandScannerState.GENERIC_CONTENT;
                                break block0;
                            }
                            case 42: {
                                break block0;
                            }
                        }
                        state = IslandScannerState.IN_MULTILINE_COMMENT;
                        break;
                    }
                    case STRING: {
                        switch (cur) {
                            case 34: {
                                state = IslandScannerState.GENERIC_CONTENT;
                                break block0;
                            }
                            case 92: {
                                state = IslandScannerState.STRING_ESCAPE;
                                break block0;
                            }
                        }
                        break;
                    }
                    case CHAR: {
                        switch (cur) {
                            case 39: {
                                state = IslandScannerState.GENERIC_CONTENT;
                                break block0;
                            }
                            case 92: {
                                state = IslandScannerState.CHAR_ESCAPE;
                                break block0;
                            }
                        }
                        break;
                    }
                    case STRING_ESCAPE: {
                        state = IslandScannerState.STRING;
                        break;
                    }
                    case CHAR_ESCAPE: {
                        state = IslandScannerState.CHAR;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unsupported state " + (Object)((Object)state)));
                    }
                }
            }
            if (state != IslandScannerState.INIT && ret.isEmpty()) {
                ret.add(TokenType.SEA);
            }
            this.previousEndState = state;
            return ret;
        }
    }

    private static enum IslandScannerState {
        INIT,
        GENERIC_CONTENT,
        POSSIBLE_COMMENT_START,
        IN_SINGLELINE_COMMENT,
        IN_MULTILINE_COMMENT,
        POSSIBLE_COMMENT_END,
        CHAR,
        CHAR_ESCAPE,
        STRING,
        STRING_ESCAPE;

    }

    private static enum TokenType {
        MULTILINE_COMMENT_START,
        MULTILINE_COMMENT_END,
        SINGLE_LINE_COMMENT,
        BRACE_OPEN,
        BRACE_CLOSE,
        SEMI,
        SEA;

    }
}

