/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.irrelevancestrategies.basicfilters;

import de.setsoftware.reviewtool.model.api.IChange;
import de.setsoftware.reviewtool.model.api.ICommit;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.ITextualChange;
import de.setsoftware.reviewtool.model.changestructure.IIrrelevanceDetermination;
import de.setsoftware.reviewtool.model.changestructure.TextualChangeHunk;

public class PackageDeclarationFilter
extends IIrrelevanceDetermination {
    public PackageDeclarationFilter(int number) {
        super(number);
    }

    public String getDescription() {
        return "ignore changes in package declarations";
    }

    public boolean isIrrelevant(ICommit commit, IChange change) {
        if (change instanceof TextualChangeHunk) {
            ITextualChange hunk = (ITextualChange)change;
            return this.isPackageDeclaration(hunk.getFromFragment()) && this.isPackageDeclaration(hunk.getToFragment());
        }
        return false;
    }

    private boolean isPackageDeclaration(IFragment fragment) {
        return fragment.getContentFullLines().trim().matches("package [^;\n]+;");
    }
}

