/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.git;

import de.setsoftware.reviewtool.base.Multimap;
import de.setsoftware.reviewtool.changesources.git.GitRepository;
import de.setsoftware.reviewtool.changesources.git.GitRevision;
import de.setsoftware.reviewtool.model.api.BackgroundJobExecutor;
import de.setsoftware.reviewtool.model.api.IChangeSourceUi;
import de.setsoftware.reviewtool.model.api.IMutableFileHistoryGraph;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

class HistoryFiller {
    private final List<GitRevision> logEntries = new ArrayList<GitRevision>();

    HistoryFiller() {
    }

    public void register(GitRevision logEntry) {
        this.logEntries.add(logEntry);
    }

    public void populate(Collection<? extends GitRevision> relevantRevisions, IChangeSourceUi ui) throws IOException {
        LinkedHashSet<GitRepository> repos = new LinkedHashSet<GitRepository>();
        long minTime = Long.MAX_VALUE;
        for (GitRevision gitRevision : relevantRevisions) {
            repos.add(gitRevision.getWorkingCopy().getRepository());
            minTime = Math.min(minTime, gitRevision.getDate().getTime());
        }
        Multimap multimap = new Multimap();
        for (GitRevision r : this.logEntries) {
            GitRepository repository = r.getWorkingCopy().getRepository();
            if (!repos.contains((Object)repository) || r.getDate().getTime() < minTime) continue;
            multimap.put((Object)repository, (Object)r);
        }
        ui.increaseTaskNestingLevel();
        try {
            for (GitRepository repo : multimap.keySet()) {
                IMutableFileHistoryGraph graph = repo.getFileHistoryGraph();
                for (GitRevision r : multimap.get((Object)repo)) {
                    if (ui.isCanceled()) {
                        throw BackgroundJobExecutor.createOperationCanceledException();
                    }
                    if (repo.wasAlreadyAnalyzed(r.getRevisionString())) continue;
                    ui.subTask("Processing revision " + r.getRevisionString());
                    r.analyzeRevision(graph);
                    repo.markAsAnalyzed(r.getRevisionString());
                }
                repo.saveCacheInBackground();
            }
        }
        finally {
            ui.decreaseTaskNestingLevel();
        }
    }
}

