/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.telemetry;

import de.setsoftware.reviewtool.telemetry.AbstractTelemetry;
import de.setsoftware.reviewtool.telemetry.TelemetryParamSource;
import java.util.LinkedHashMap;
import java.util.Map;

public class TelemetryEventBuilder {
    private final AbstractTelemetry telemetry;
    private final String type;
    private final Map<String, String> params;

    TelemetryEventBuilder(AbstractTelemetry telemetry, String type) {
        this.telemetry = telemetry;
        this.type = type;
        this.params = new LinkedHashMap<String, String>();
    }

    public TelemetryEventBuilder param(String name, Object value) {
        assert (!this.params.containsKey(name));
        this.params.put(name, value.toString());
        return this;
    }

    public TelemetryEventBuilder param(String name, long value) {
        return this.param(name, Long.toString(value));
    }

    public TelemetryEventBuilder params(TelemetryParamSource paramSource) {
        paramSource.addParams(this);
        return this;
    }

    public void log() {
        this.telemetry.log(this.type, this.params);
    }
}

