/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.viewtracking;

import de.setsoftware.reviewtool.base.WeakListeners;
import de.setsoftware.reviewtool.model.api.IClassification;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.changestructure.Stop;
import de.setsoftware.reviewtool.model.changestructure.Tour;
import de.setsoftware.reviewtool.model.changestructure.ToursInReview;
import de.setsoftware.reviewtool.model.viewtracking.IViewStatisticsListener;
import de.setsoftware.reviewtool.model.viewtracking.ViewStatDataForStop;
import de.setsoftware.reviewtool.model.viewtracking.ViewStatisticsForFile;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ViewStatistics {
    private final Map<File, ViewStatisticsForFile> files = new HashMap<File, ViewStatisticsForFile>();
    private final WeakListeners<IViewStatisticsListener> listeners = new WeakListeners();
    private final Set<Stop> explicitMarks = new HashSet<Stop>();

    public void mark(File filePath, int fromLine, int toLine) {
        File absFile = filePath.getAbsoluteFile();
        this.getOrCreate(absFile).mark(fromLine, toLine);
        this.notifyListeners(absFile);
    }

    public void markUnknownPosition(File filePath) {
        File absFile = filePath.getAbsoluteFile();
        this.getOrCreate(absFile).markUnknownPosition();
        this.notifyListeners(absFile);
    }

    public void toggleExplicitlyCheckedMark(Collection<Stop> stops) {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (Stop stop : stops) {
            if (this.isMarkedAsChecked(stop)) {
                this.explicitMarks.remove(stop);
            } else {
                this.explicitMarks.add(stop);
            }
            files.add(stop.getAbsoluteFile());
        }
        for (File file : files) {
            this.notifyListeners(file);
        }
    }

    public boolean isMarkedAsChecked(Stop stop) {
        return this.explicitMarks.contains(stop);
    }

    private ViewStatisticsForFile getOrCreate(File absFile) {
        ViewStatisticsForFile ret = this.files.get(absFile);
        if (ret == null) {
            ret = new ViewStatisticsForFile();
            this.files.put(absFile, ret);
        }
        return ret;
    }

    public ViewStatDataForStop determineViewRatio(Stop f, int longEnoughCount) {
        File absFile = f.getAbsoluteFile();
        ViewStatisticsForFile stats = this.files.get(absFile);
        if (stats == null) {
            return ViewStatDataForStop.NO_VIEWS;
        }
        IFragment fragment = f.getMostRecentFragment();
        if (fragment == null) {
            return stats.determineViewRatioWithoutPosition(longEnoughCount);
        }
        int toCorrection = fragment.getTo().getColumn() == 1 ? -1 : 0;
        return stats.determineViewRatio(fragment.getFrom().getLine(), fragment.getTo().getLine() + toCorrection, longEnoughCount);
    }

    private void notifyListeners(File absFile) {
        this.listeners.notifyListeners((T l) -> l.statisticsChanged(absFile));
    }

    public void addListener(IViewStatisticsListener listener) {
        this.listeners.add(listener);
    }

    public Stop getNextUnvisitedStop(ToursInReview tours, Stop currentStop, INextStopCallback nextStopCallback) {
        if (tours.getTopmostTours().isEmpty()) {
            return null;
        }
        int startTourIndex = tours.findTourIndexWithStop(currentStop);
        int tourCount = tours.getTopmostTours().size();
        int i = 0;
        while (i <= tourCount) {
            Tour tour = tours.getTopmostTours().get((startTourIndex + i) % tourCount);
            List<Stop> remainingStops = i == 0 ? tour.getStopsAfter(currentStop) : (i == tourCount ? tour.getStopsBefore(currentStop) : tour.getStops());
            for (Stop possibleNextStop : remainingStops) {
                if (!this.shouldStillVisit(possibleNextStop, tours.getIrrelevantCategories())) continue;
                if (i > 0 || !tour.getStops().contains(currentStop)) {
                    if (startTourIndex + i >= tourCount) {
                        nextStopCallback.wrappedAround();
                    }
                    if (i < tourCount) {
                        nextStopCallback.newTourStarted(tour);
                    }
                }
                return possibleNextStop;
            }
            ++i;
        }
        return null;
    }

    private boolean shouldStillVisit(Stop possibleNextStop, Set<? extends IClassification> irrelevantCategories) {
        return this.determineViewRatio(possibleNextStop, 1).isPartlyUnvisited() && !this.explicitMarks.contains(possibleNextStop) && !possibleNextStop.isIrrelevantForReview(irrelevantCategories);
    }

    public static interface INextStopCallback {
        public void newTourStarted(Tour var1);

        public void wrappedAround();
    }
}

