/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.model.api.IClassification;
import de.setsoftware.reviewtool.model.changestructure.Classification;
import de.setsoftware.reviewtool.model.changestructure.Stop;
import de.setsoftware.reviewtool.model.changestructure.TourElement;
import de.setsoftware.reviewtool.telemetry.TelemetryEventBuilder;
import de.setsoftware.reviewtool.telemetry.TelemetryParamSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Tour
extends TourElement {
    private final String description;
    private final List<TourElement> children = new ArrayList<TourElement>();

    public Tour(String description, List<? extends TourElement> list) {
        this.description = description;
        this.children.addAll(list);
    }

    public String toString() {
        return "Tour: " + this.description + ", " + this.children;
    }

    public int hashCode() {
        return this.description.hashCode() + this.children.size();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Tour)) {
            return false;
        }
        Tour t = (Tour)o;
        return this.description.equals(t.description) && this.children.equals(t.children);
    }

    public List<Stop> getStops() {
        ArrayList<Stop> buffer = new ArrayList<Stop>();
        this.fillStopsInto(buffer);
        return Collections.unmodifiableList(buffer);
    }

    @Override
    protected void fillStopsInto(List<Stop> buffer) {
        for (TourElement e : this.children) {
            e.fillStopsInto(buffer);
        }
    }

    public List<? extends TourElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public String getDescription() {
        return this.description;
    }

    public List<Stop> getStopsAfter(Stop currentStop) {
        List<Stop> allStops = this.getStops();
        int index = allStops.indexOf(currentStop);
        return allStops.subList(index + 1, allStops.size());
    }

    public List<Stop> getStopsBefore(Stop currentStop) {
        List<Stop> allStops = this.getStops();
        int index = allStops.indexOf(currentStop);
        return index <= 0 ? Collections.emptyList() : allStops.subList(0, index - 1);
    }

    public int getNumberOfStops(boolean onlyRelevant, Set<? extends IClassification> irrelevantCategories) {
        return this.filterRelevance(onlyRelevant, irrelevantCategories).size();
    }

    public int getNumberOfFragments(boolean onlyRelevant, Set<? extends IClassification> irrelevantCategories) {
        int ret = 0;
        for (Stop s : this.filterRelevance(onlyRelevant, irrelevantCategories)) {
            ret += s.getNumberOfFragments();
        }
        return ret;
    }

    public int getNumberOfAddedLines(boolean onlyRelevant, Set<? extends IClassification> irrelevantCategories) {
        int ret = 0;
        for (Stop s : this.filterRelevance(onlyRelevant, irrelevantCategories)) {
            ret += s.getNumberOfAddedLines();
        }
        return ret;
    }

    public int getNumberOfRemovedLines(boolean onlyRelevant, Set<? extends IClassification> irrelevantCategories) {
        int ret = 0;
        for (Stop s : this.filterRelevance(onlyRelevant, irrelevantCategories)) {
            ret += s.getNumberOfRemovedLines();
        }
        return ret;
    }

    private List<Stop> filterRelevance(boolean onlyRelevant, Set<? extends IClassification> irrelevantCategories) {
        if (onlyRelevant) {
            ArrayList<Stop> ret = new ArrayList<Stop>();
            for (Stop s : this.getStops()) {
                if (s.isIrrelevantForReview(irrelevantCategories)) continue;
                ret.add(s);
            }
            return ret;
        }
        return this.getStops();
    }

    public static TelemetryParamSource determineSize(final List<? extends Tour> tours, final Set<? extends IClassification> irrelevantCategories) {
        return new TelemetryParamSource(){

            @Override
            public void addParams(TelemetryEventBuilder event) {
                if (tours == null) {
                    event.param("cntTours", "-1");
                    return;
                }
                int numberOfStops = 0;
                int numberOfFragments = 0;
                int numberOfAddedLines = 0;
                int numberOfRemovedLines = 0;
                int numberOfStopsRel = 0;
                int numberOfFragmentsRel = 0;
                int numberOfAddedLinesRel = 0;
                int numberOfRemovedLinesRel = 0;
                for (Tour t : tours) {
                    numberOfStops += t.getNumberOfStops(false, irrelevantCategories);
                    numberOfFragments += t.getNumberOfFragments(false, irrelevantCategories);
                    numberOfAddedLines += t.getNumberOfAddedLines(false, irrelevantCategories);
                    numberOfRemovedLines += t.getNumberOfRemovedLines(false, irrelevantCategories);
                    numberOfStopsRel += t.getNumberOfStops(true, irrelevantCategories);
                    numberOfFragmentsRel += t.getNumberOfFragments(true, irrelevantCategories);
                    numberOfAddedLinesRel += t.getNumberOfAddedLines(true, irrelevantCategories);
                    numberOfRemovedLinesRel += t.getNumberOfRemovedLines(true, irrelevantCategories);
                }
                event.param("cntTours", tours.size());
                event.param("cntStops", numberOfStops);
                event.param("cntFragments", numberOfFragments);
                event.param("cntAddedLines", numberOfAddedLines);
                event.param("cntRemovedLines", numberOfRemovedLines);
                event.param("cntStopsRel", numberOfStopsRel);
                event.param("cntFragmentsRel", numberOfFragmentsRel);
                event.param("cntAddedLinesRel", numberOfAddedLinesRel);
                event.param("cntRemovedLinesRel", numberOfRemovedLinesRel);
            }
        };
    }

    Tour findParentFor(TourElement element) {
        for (TourElement child : this.children) {
            Tour recursiveResult;
            if (child.equals(element)) {
                return this;
            }
            if (!(child instanceof Tour) || (recursiveResult = ((Tour)child).findParentFor(element)) == null) continue;
            return recursiveResult;
        }
        return null;
    }

    @Override
    public IClassification[] getClassification() {
        if (this.children.isEmpty()) {
            return Classification.NONE;
        }
        Iterator<TourElement> iter = this.children.iterator();
        LinkedHashSet<IClassification> ret = new LinkedHashSet<IClassification>(Arrays.asList(iter.next().getClassification()));
        while (iter.hasNext()) {
            ret.retainAll(Arrays.asList(iter.next().getClassification()));
            if (!ret.isEmpty()) continue;
            return Classification.NONE;
        }
        return ret.toArray(new IClassification[ret.size()]);
    }

    public List<Stop> getStopsFor(File absolutePath) {
        ArrayList<Stop> ret = new ArrayList<Stop>();
        for (Stop s : this.getStops()) {
            if (!absolutePath.equals(s.getAbsoluteFile())) continue;
            ret.add(s);
        }
        return ret;
    }
}

