/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.model.api.IChange;
import de.setsoftware.reviewtool.model.api.ICommit;
import de.setsoftware.reviewtool.model.api.IRevision;
import de.setsoftware.reviewtool.model.api.IWorkingCopy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Function;

public class Commit
implements ICommit {
    private final IWorkingCopy wc;
    private final String message;
    private final List<IChange> changes;
    private final IRevision revision;
    private final long timestamp;

    Commit(IWorkingCopy wc, String message, List<? extends IChange> changes, IRevision revision, Date timestamp) {
        this.wc = wc;
        this.message = message;
        this.changes = new ArrayList<IChange>(changes);
        this.revision = revision;
        this.timestamp = timestamp.getTime();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public IRevision getRevision() {
        return this.revision;
    }

    @Override
    public List<? extends IChange> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    @Override
    public Commit transformChanges(Function<IChange, IChange> f) {
        ArrayList<IChange> adjustedChanges = new ArrayList<IChange>(this.changes.size());
        for (IChange change : this.changes) {
            adjustedChanges.add(f.apply(change));
        }
        return new Commit(this.wc, this.message, adjustedChanges, this.revision, this.getTime());
    }

    @Override
    public Date getTime() {
        return new Date(this.timestamp);
    }

    @Override
    public IWorkingCopy getWorkingCopy() {
        return this.wc;
    }
}

