/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.config;

import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.config.IConfigurator;
import de.setsoftware.reviewtool.config.IReviewConfigurable;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigurationInterpreter {
    public static final String USER_PARAM_NAME = "User-ID";
    private final List<IConfigurator> configurators = new ArrayList<IConfigurator>();

    public void addConfigurator(IConfigurator configurator) {
        this.configurators.add(configurator);
    }

    public Set<String> getUserSpecificParamNames(Document configuration) {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        ret.add(USER_PARAM_NAME);
        this.getUserSpecificParamNamesRec(configuration.getDocumentElement(), ret);
        return ret;
    }

    private void getUserSpecificParamNamesRec(Element element, Set<String> nameBuffer) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node n = nodes.item(i);
            NamedNodeMap atts = n.getAttributes();
            if (atts != null) {
                int j = 0;
                while (j < atts.getLength()) {
                    this.parseParamNamesFromValue(atts.item(j).getNodeValue(), nameBuffer);
                    ++j;
                }
            }
            if (n instanceof Element) {
                this.getUserSpecificParamNamesRec((Element)n, nameBuffer);
            }
            ++i;
        }
    }

    private void parseParamNamesFromValue(String nodeValue, Set<String> ret) {
        List<String> parts = this.parseValue(nodeValue);
        int i = 1;
        while (i < parts.size()) {
            ret.add(parts.get(i));
            i += 2;
        }
    }

    private List<String> parseValue(String value) {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder curPart = new StringBuilder();
        ParseState state = ParseState.OUT;
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            switch (state) {
                case OUT: {
                    if (ch == '$') {
                        state = ParseState.FIRST;
                        break;
                    }
                    curPart.append(ch);
                    break;
                }
                case FIRST: {
                    if (ch == '$') {
                        curPart.append('$');
                        state = ParseState.OUT;
                        break;
                    }
                    if (ch == '{') {
                        ret.add(curPart.toString());
                        curPart.setLength(0);
                        state = ParseState.IN;
                        break;
                    }
                    throw new ReviewtoolException("Syntax error $" + ch + " in " + value);
                }
                case IN: {
                    if (ch == '}') {
                        ret.add(curPart.toString());
                        curPart.setLength(0);
                        state = ParseState.OUT;
                        break;
                    }
                    curPart.append(ch);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            ++n2;
        }
        if (state != ParseState.OUT) {
            throw new ReviewtoolException("Open parameter name in " + value);
        }
        ret.add(curPart.toString());
        return ret;
    }

    public void configure(Document configuration, Map<String, String> paramValues, IReviewConfigurable configurable) {
        Element withParamsReplaced = (Element)configuration.getDocumentElement().cloneNode(true);
        this.replaceParams(withParamsReplaced, paramValues);
        this.callConfigurators(configurable, withParamsReplaced);
    }

    private void replaceParams(Element element, Map<String, String> paramValues) {
        NamedNodeMap atts = element.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            Attr att = (Attr)atts.item(i);
            att.setValue(this.replaceParamsInValue(att.getValue(), paramValues));
            ++i;
        }
        NodeList children = element.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node child = children.item(i2);
            if (child instanceof Element) {
                this.replaceParams((Element)child, paramValues);
            }
            ++i2;
        }
    }

    private String replaceParamsInValue(String value, Map<String, String> paramValues) {
        StringBuilder ret = new StringBuilder();
        List<String> parts = this.parseValue(value);
        int i = 0;
        while (i < parts.size()) {
            if (i % 2 == 0) {
                ret.append(parts.get(i));
            } else {
                String paramName = parts.get(i);
                if (paramName.startsWith("env.")) {
                    String envVariableName = paramName.substring(4);
                    String paramValue = System.getenv(envVariableName);
                    if (paramValue == null) {
                        throw new ReviewtoolException("Environment variable " + envVariableName + " is not set (reqired for parameter " + paramName + ")");
                    }
                    ret.append(paramValue);
                } else {
                    String paramValue = paramValues.get(paramName);
                    if (paramValue == null) {
                        throw new ReviewtoolException("Value for user specific parameter " + paramName + " missing.");
                    }
                    ret.append(paramValue);
                }
            }
            ++i;
        }
        return ret.toString();
    }

    private void callConfigurators(IReviewConfigurable configurable, Element rootElement) {
        NodeList children = rootElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            for (IConfigurator configurator : this.configurators) {
                if (!configurator.getRelevantElementNames().contains(child.getNodeName())) continue;
                Element clone = (Element)child.cloneNode(true);
                configurator.configure(clone, configurable);
            }
            ++i;
        }
    }

    public static Document load(String filename) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream stream = new FileInputStream(filename);){
            return f.newDocumentBuilder().parse(new InputSource(stream));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static enum ParseState {
        OUT,
        FIRST,
        IN;

    }
}

