/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.base;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LineSequence {
    private final List<String> lines = new ArrayList<String>();
    private final Map<Integer, Integer> lineOffsets = new HashMap<Integer, Integer>();

    public LineSequence() {
        this.lineOffsets.put(0, 0);
    }

    public LineSequence(byte[] contents, String charset) throws IOException {
        this();
        String line;
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(contents), charset));
        while ((line = r.readLine()) != null) {
            this.addLine(String.valueOf(line) + '\n');
        }
    }

    public void addLine(String line) {
        this.lines.add(line);
        this.lineOffsets.put(this.lines.size(), this.lineOffsets.get(this.lines.size() - 1) + line.length());
    }

    public int getNumberOfLines() {
        return this.lines.size();
    }

    public String getLine(int lineIndex) {
        return this.lines.get(lineIndex);
    }

    public String[] getLines(int fromIndex, int toIndex) {
        return this.lines.subList(fromIndex, toIndex).toArray(new String[0]);
    }

    public String getLinesConcatenated(int fromIndex, int toIndex) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = this.getLines(fromIndex, toIndex);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            builder.append(s);
            ++n2;
        }
        return builder.toString();
    }

    public int getStartPositionOfLine(int lineIndex) {
        return this.lineOffsets.get(lineIndex);
    }
}

