/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.remarks;

import de.setsoftware.reviewtool.model.remarks.RemarkType;
import de.setsoftware.reviewtool.model.remarks.ReviewRemark;
import de.setsoftware.reviewtool.model.remarks.ReviewRemarkException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReviewRound {
    public static final String[] POSITIVE_HEADER = new String[]{"positiv"};
    public static final String[] MUST_FIX_HEADER = new String[]{"muss", "wichtig"};
    public static final String[] CAN_FIX_HEADER = new String[]{"kann", "optional / weniger wichtig"};
    public static final String[] ALREADY_FIXED_HEADER = new String[]{"direkt eingepflegt"};
    public static final String[] TEMPORARY_HEADER = new String[]{"tempor\u00e4rer Marker"};
    public static final String[] OTHER_REMARK_HEADER = new String[]{"sonstige Anmerkungen"};
    private final int nbr;
    private final List<ReviewRemark> remarks = new ArrayList<ReviewRemark>();

    public ReviewRound(int nbr) {
        this.nbr = nbr;
    }

    public int getNumber() {
        return this.nbr;
    }

    public void merge(ReviewRemark reviewRemark) throws ReviewRemarkException {
        int index = this.findSimilar(reviewRemark);
        if (index >= 0) {
            this.remarks.set(index, reviewRemark);
        } else {
            this.add(reviewRemark);
        }
    }

    private int findSimilar(ReviewRemark reviewRemark) throws ReviewRemarkException {
        int i = 0;
        for (ReviewRemark r : this.remarks) {
            if (r.hasSameTextAndPositionAs(reviewRemark)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void add(ReviewRemark reviewRemark) {
        int index = this.findInsertionIndex(reviewRemark);
        this.remarks.add(index, reviewRemark);
    }

    private int findInsertionIndex(ReviewRemark reviewRemark) {
        int i = 0;
        while (i < this.remarks.size()) {
            if (this.remarks.get(i).hasLargerPositionThan(reviewRemark)) {
                return i;
            }
            ++i;
        }
        return this.remarks.size();
    }

    public boolean isEmpty() {
        return this.remarks.isEmpty();
    }

    public String serialize() throws ReviewRemarkException {
        StringBuilder ret = new StringBuilder();
        ret.append("Review ").append(this.nbr).append(":\n");
        this.serializeRemarksWithType(OTHER_REMARK_HEADER[0], ret, RemarkType.OTHER);
        this.serializeRemarksWithType(POSITIVE_HEADER[0], ret, RemarkType.POSITIVE);
        this.serializeRemarksWithType(MUST_FIX_HEADER[0], ret, RemarkType.MUST_FIX);
        this.serializeRemarksWithType(CAN_FIX_HEADER[0], ret, RemarkType.CAN_FIX);
        this.serializeRemarksWithType(ALREADY_FIXED_HEADER[0], ret, RemarkType.ALREADY_FIXED);
        this.serializeRemarksWithType(TEMPORARY_HEADER[0], ret, RemarkType.TEMPORARY);
        return ret.toString();
    }

    private void serializeRemarksWithType(String title, StringBuilder ret, RemarkType type) throws ReviewRemarkException {
        boolean titleWritten = false;
        for (ReviewRemark remark : this.remarks) {
            if (remark.getRemarkType() != type) continue;
            if (!titleWritten) {
                ret.append("* ").append(title).append("\n");
                titleWritten = true;
            }
            ret.append(remark.serialize());
        }
    }

    public static RemarkType parseType(String string) {
        if (Arrays.asList(ALREADY_FIXED_HEADER).contains(string)) {
            return RemarkType.ALREADY_FIXED;
        }
        if (Arrays.asList(CAN_FIX_HEADER).contains(string)) {
            return RemarkType.CAN_FIX;
        }
        if (Arrays.asList(MUST_FIX_HEADER).contains(string)) {
            return RemarkType.MUST_FIX;
        }
        if (Arrays.asList(POSITIVE_HEADER).contains(string)) {
            return RemarkType.POSITIVE;
        }
        if (Arrays.asList(TEMPORARY_HEADER).contains(string)) {
            return RemarkType.TEMPORARY;
        }
        if (Arrays.asList(OTHER_REMARK_HEADER).contains(string)) {
            return RemarkType.OTHER;
        }
        return null;
    }

    public boolean hasUnresolvedRemarks() throws ReviewRemarkException {
        for (ReviewRemark r : this.remarks) {
            if (!r.needsFixing()) continue;
            return true;
        }
        return false;
    }

    public boolean hasTemporaryMarkers() throws ReviewRemarkException {
        for (ReviewRemark r : this.remarks) {
            if (r.getRemarkType() != RemarkType.TEMPORARY) continue;
            return true;
        }
        return false;
    }

    public void deleteRemark(ReviewRemark reviewRemark) throws ReviewRemarkException {
        int i = this.findSimilar(reviewRemark);
        if (i >= 0) {
            this.remarks.remove(i);
        }
    }

    public boolean contains(ReviewRemark reviewRemark) {
        return this.findSimilar(reviewRemark) >= 0;
    }

    public List<ReviewRemark> getRemarks() {
        return this.remarks;
    }
}

