/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.svn;

import de.setsoftware.reviewtool.changesources.svn.ISvnRepo;
import de.setsoftware.reviewtool.diffalgorithms.DiffAlgorithmFactory;
import de.setsoftware.reviewtool.model.api.IFileHistoryGraph;
import de.setsoftware.reviewtool.model.api.IMutableFileHistoryGraph;
import de.setsoftware.reviewtool.model.changestructure.AbstractWorkingCopy;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryGraph;
import de.setsoftware.reviewtool.model.changestructure.VirtualFileHistoryGraph;
import java.io.File;
import java.nio.file.Path;

final class SvnWorkingCopy
extends AbstractWorkingCopy {
    private final ISvnRepo repo;
    private final File workingCopyRoot;
    private final VirtualFileHistoryGraph combinedFileHistoryGraph;

    SvnWorkingCopy(ISvnRepo repo, File workingCopyRoot) {
        this.repo = repo;
        this.workingCopyRoot = workingCopyRoot;
        this.combinedFileHistoryGraph = new VirtualFileHistoryGraph((IFileHistoryGraph)repo.getFileHistoryGraph());
        this.setLocalFileHistoryGraph((IMutableFileHistoryGraph)new FileHistoryGraph(DiffAlgorithmFactory.createDefault()));
    }

    public ISvnRepo getRepository() {
        return this.repo;
    }

    public File getLocalRoot() {
        return this.workingCopyRoot;
    }

    public File toAbsolutePathInWc(String absolutePathInRepo) {
        String relPath = this.repo.getRelativePath();
        if (absolutePathInRepo.equals(relPath)) {
            return this.workingCopyRoot;
        }
        if (absolutePathInRepo.startsWith(String.valueOf(relPath) + "/")) {
            assert (!absolutePathInRepo.contains("\\"));
            return new File(this.workingCopyRoot, absolutePathInRepo.substring(relPath.length() + 1));
        }
        return null;
    }

    public String toAbsolutePathInRepo(File absolutePathInWc) {
        Path wcRootPath = this.workingCopyRoot.toPath();
        Path wcPath = absolutePathInWc.toPath();
        if (wcPath.startsWith(wcRootPath)) {
            String relPath = this.repo.getRelativePath();
            try {
                String relativePath = wcRootPath.relativize(wcPath).toString().replaceAll("\\\\", "/");
                return String.valueOf(relPath) + '/' + relativePath;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public VirtualFileHistoryGraph getFileHistoryGraph() {
        return this.combinedFileHistoryGraph;
    }

    public String toString() {
        return this.workingCopyRoot.toString();
    }

    IMutableFileHistoryGraph getLocalFileHistoryGraph() {
        return (IMutableFileHistoryGraph)this.combinedFileHistoryGraph.getLocalFileHistoryGraph();
    }

    void setLocalFileHistoryGraph(IMutableFileHistoryGraph localFileHistoryGraph) {
        this.combinedFileHistoryGraph.setLocalFileHistoryGraph((IFileHistoryGraph)localFileHistoryGraph);
    }
}

