/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.core.ui.intellij.views.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextAreaKt;
import com.intellij.ui.dsl.builder.TextFieldKt;
import de.setsoftware.reviewtool.core.ui.intellij.model.IntelliJRessource;
import de.setsoftware.reviewtool.core.ui.intellij.plugin.CortLineGutterIconUpdater;
import de.setsoftware.reviewtool.core.ui.intellij.plugin.ReviewPlugin;
import de.setsoftware.reviewtool.model.PositionTransformer;
import de.setsoftware.reviewtool.model.api.PositionReference;
import de.setsoftware.reviewtool.model.reflectionExtensions.ReviewStateManagerExtension;
import de.setsoftware.reviewtool.model.remarks.GlobalPosition;
import de.setsoftware.reviewtool.model.remarks.IReviewResource;
import de.setsoftware.reviewtool.model.remarks.Position;
import de.setsoftware.reviewtool.model.remarks.RemarkType;
import de.setsoftware.reviewtool.model.remarks.ReviewRemark;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB'\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0006H\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0002J\u0012\u0010\u0015\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/views/dialogs/CreateRemarkDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "possibleReferences", "", "Lde/setsoftware/reviewtool/model/api/PositionReference;", "prefillText", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/util/Collection;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "selectedRemarkType", "Lde/setsoftware/reviewtool/model/remarks/RemarkType;", "reviewRemark", "positionReference", "getDimensionServiceKey", "createCenterPanel", "Ljavax/swing/JComponent;", "remarkTypeRenderer", "Lcom/intellij/ui/SimpleListCellRenderer;", "positionRenderer", "furtherInit", "", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBTextArea;", "ConfirmOnTextAreaEnterKeyListener", "Companion", "IntelliJ-CoRT"})
public final class CreateRemarkDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<PositionReference> possibleReferences;
    @NotNull
    private RemarkType selectedRemarkType;
    @NotNull
    private String reviewRemark;
    @NotNull
    private PositionReference positionReference;

    private CreateRemarkDialog(Collection<? extends PositionReference> possibleReferences, String prefillText, Project project) {
        super(project);
        this.possibleReferences = possibleReferences;
        this.selectedRemarkType = RemarkType.MUST_FIX;
        this.reviewRemark = prefillText;
        this.positionReference = PositionReference.LINE;
        this.setTitle("Review-Anmerkung Schreiben");
        this.init();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "de.set.reviewtool.createRemarkDialog";
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBPanel jBPanel = BuilderKt.panel(arg_0 -> CreateRemarkDialog.createCenterPanel$lambda$3(this, arg_0)).withMinimumWidth(600);
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"withMinimumWidth(...)");
        DialogPanel panel2 = (DialogPanel)jBPanel;
        return (JComponent)panel2;
    }

    private final SimpleListCellRenderer<RemarkType> remarkTypeRenderer() {
        SimpleListCellRenderer simpleListCellRenderer = SimpleListCellRenderer.create((String)"", arg_0 -> CreateRemarkDialog.remarkTypeRenderer$lambda$5(CreateRemarkDialog::remarkTypeRenderer$lambda$4, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)simpleListCellRenderer, (String)"create(...)");
        return simpleListCellRenderer;
    }

    private final SimpleListCellRenderer<PositionReference> positionRenderer() {
        SimpleListCellRenderer simpleListCellRenderer = SimpleListCellRenderer.create((String)"", arg_0 -> CreateRemarkDialog.positionRenderer$lambda$7(CreateRemarkDialog::positionRenderer$lambda$6, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)simpleListCellRenderer, (String)"create(...)");
        return simpleListCellRenderer;
    }

    private final void furtherInit(Cell<? extends JBTextArea> $this$furtherInit) {
        ((JBTextArea)$this$furtherInit.getComponent()).setLineWrap(true);
        ((JBTextArea)$this$furtherInit.getComponent()).setWrapStyleWord(true);
        ((JBTextArea)$this$furtherInit.getComponent()).setFocusTraversalKeys(0, null);
        ((JBTextArea)$this$furtherInit.getComponent()).setFocusTraversalKeys(1, null);
        ((JBTextArea)$this$furtherInit.getComponent()).addKeyListener((KeyListener)new ConfirmOnTextAreaEnterKeyListener());
    }

    private static final Unit createCenterPanel$lambda$3$lambda$0(CreateRemarkDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ComboBoxKt.bindItem((Cell)$this$row.comboBox((ComboBoxModel)new EnumComboBoxModel(RemarkType.class), (ListCellRenderer)this$0.remarkTypeRenderer()), (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return CreateRemarkDialog.access$getSelectedRemarkType$p((CreateRemarkDialog)((Object)this.receiver));
            }

            public void set(Object value) {
                CreateRemarkDialog.access$setSelectedRemarkType$p((CreateRemarkDialog)((Object)this.receiver), (RemarkType)value);
            }
        }))).focused();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$3$lambda$1(CreateRemarkDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.furtherInit((Cell<? extends JBTextArea>)TextAreaKt.rows((Cell)TextFieldKt.bindText((Cell)$this$row.textArea(), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return CreateRemarkDialog.access$getReviewRemark$p((CreateRemarkDialog)((Object)this.receiver));
            }

            public void set(Object value) {
                CreateRemarkDialog.access$setReviewRemark$p((CreateRemarkDialog)((Object)this.receiver), (String)value);
            }
        })).resizableColumn().align(Align.FILL), (int)2));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$3$lambda$2(CreateRemarkDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ComboBoxKt.bindItem((Cell)$this$row.comboBox(this$0.possibleReferences, (ListCellRenderer)this$0.positionRenderer()), (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return CreateRemarkDialog.access$getPositionReference$p((CreateRemarkDialog)((Object)this.receiver));
            }

            public void set(Object value) {
                CreateRemarkDialog.access$setPositionReference$p((CreateRemarkDialog)((Object)this.receiver), (PositionReference)value);
            }
        })));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$3(CreateRemarkDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row("Typ:", arg_0 -> CreateRemarkDialog.createCenterPanel$lambda$3$lambda$0(this$0, arg_0));
        $this$panel.row("Anmerkung:", arg_0 -> CreateRemarkDialog.createCenterPanel$lambda$3$lambda$1(this$0, arg_0)).resizableRow();
        $this$panel.row("Position:", arg_0 -> CreateRemarkDialog.createCenterPanel$lambda$3$lambda$2(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final String remarkTypeRenderer$lambda$4(RemarkType it) {
        RemarkType remarkType = it;
        return switch (remarkType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[remarkType.ordinal()]) {
            case 1 -> "muss";
            case 2 -> "kann";
            case 3 -> "direkt eingepflegt";
            case 4 -> "positiv";
            case 5 -> "tempor\u00e4rer Marker";
            case 6 -> "sonstige Anmerkung";
            case -1 -> "";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final String remarkTypeRenderer$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String positionRenderer$lambda$6(PositionReference it) {
        PositionReference positionReference = it;
        return switch (positionReference == null ? -1 : WhenMappings.$EnumSwitchMapping$1[positionReference.ordinal()]) {
            case 1 -> "Zeile";
            case 2 -> "Datei";
            case 3 -> "Global";
            case -1 -> "";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final String positionRenderer$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public /* synthetic */ CreateRemarkDialog(Collection possibleReferences, String prefillText, Project project, DefaultConstructorMarker $constructor_marker) {
        this(possibleReferences, prefillText, project);
    }

    public static final /* synthetic */ void access$setSelectedRemarkType$p(CreateRemarkDialog $this, RemarkType remarkType) {
        $this.selectedRemarkType = remarkType;
    }

    public static final /* synthetic */ void access$setReviewRemark$p(CreateRemarkDialog $this, String string) {
        $this.reviewRemark = string;
    }

    public static final /* synthetic */ void access$setPositionReference$p(CreateRemarkDialog $this, PositionReference positionReference) {
        $this.positionReference = positionReference;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J&\u0010\u0011\u001a\u00020\u00122\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\bH\u0002\u00a8\u0006\u0014"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/views/dialogs/CreateRemarkDialog$Companion;", "", "<init>", "()V", "get", "", "possibleReferences", "", "Lde/setsoftware/reviewtool/model/api/PositionReference;", "prefillText", "", "fileWithLine", "Lkotlin/Pair;", "Ljava/io/File;", "", "project", "Lcom/intellij/openapi/project/Project;", "calculatePosition", "Lde/setsoftware/reviewtool/model/remarks/Position;", "ref", "IntelliJ-CoRT"})
    public static final class Companion {
        private Companion() {
        }

        public final void get(@NotNull Set<? extends PositionReference> possibleReferences, @NotNull String prefillText, @Nullable Pair<? extends File, Integer> fileWithLine, @NotNull Project project) {
            Intrinsics.checkNotNullParameter(possibleReferences, (String)"possibleReferences");
            Intrinsics.checkNotNullParameter((Object)prefillText, (String)"prefillText");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            CreateRemarkDialog dialog = new CreateRemarkDialog(possibleReferences, prefillText, project, null);
            boolean shouldCreateRemark = dialog.showAndGet();
            if (shouldCreateRemark) {
                IReviewResource resource = new IntelliJRessource(this.calculatePosition(fileWithLine, dialog.positionReference), project);
                ReviewStateManagerExtension p = ReviewPlugin.Companion.getInstance(project).getPersistence();
                String user = p.getReviewerForCurrentRound();
                Pair<? extends File, Integer> pair = fileWithLine;
                ReviewRemark reviewRemark = ReviewRemark.create((IReviewResource)resource, (String)user, (String)dialog.reviewRemark, (int)(pair != null ? ((Number)pair.getSecond()).intValue() : 0), (RemarkType)dialog.selectedRemarkType);
                p.saveRemark(reviewRemark);
                CortLineGutterIconUpdater.Companion.updateIconsForAllCurrentlyOpenedDocuments(project);
            }
        }

        private final Position calculatePosition(Pair<? extends File, Integer> fileWithLine, PositionReference ref) {
            Position position;
            if (fileWithLine == null) {
                return (Position)new GlobalPosition();
            }
            switch (WhenMappings.$EnumSwitchMapping$0[ref.ordinal()]) {
                case 1: {
                    Position position2 = PositionTransformer.toPosition((File)((File)fileWithLine.getFirst()), (int)((Number)fileWithLine.getSecond()).intValue());
                    position = position2;
                    Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"toPosition(...)");
                    break;
                }
                case 2: {
                    Position position3 = PositionTransformer.toPosition((File)((File)fileWithLine.getFirst()), (int)0);
                    position = position3;
                    Intrinsics.checkNotNullExpressionValue((Object)position3, (String)"toPosition(...)");
                    break;
                }
                case 3: {
                    position = (Position)new GlobalPosition();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return position;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PositionReference.values().length];
                try {
                    nArray[PositionReference.LINE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PositionReference.FILE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PositionReference.GLOBAL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/views/dialogs/CreateRemarkDialog$ConfirmOnTextAreaEnterKeyListener;", "Ljava/awt/event/KeyAdapter;", "<init>", "(Lde/setsoftware/reviewtool/core/ui/intellij/views/dialogs/CreateRemarkDialog;)V", "keyPressed", "", "e", "Ljava/awt/event/KeyEvent;", "IntelliJ-CoRT"})
    private final class ConfirmOnTextAreaEnterKeyListener
    extends KeyAdapter {
        @Override
        public void keyPressed(@Nullable KeyEvent e) {
            boolean bl = e != null ? 10 == e.getKeyCode() : false;
            if (bl) {
                e.consume();
                CreateRemarkDialog.this.clickDefaultButton();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RemarkType.values().length];
            try {
                nArray[RemarkType.MUST_FIX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemarkType.CAN_FIX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemarkType.ALREADY_FIXED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemarkType.POSITIVE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemarkType.TEMPORARY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemarkType.OTHER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PositionReference.values().length];
            try {
                nArray[PositionReference.LINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionReference.FILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionReference.GLOBAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

