/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.core.ui.intellij.views.dialogs;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBTextArea;
import de.setsoftware.reviewtool.model.IReviewDataCache;
import de.setsoftware.reviewtool.model.ITicketConnector;
import de.setsoftware.reviewtool.model.IUserInteraction;
import de.setsoftware.reviewtool.model.InMemoryReviewDataCache;
import de.setsoftware.reviewtool.model.PersistenceStub;
import de.setsoftware.reviewtool.model.ReviewStateManager;
import de.setsoftware.reviewtool.model.StubUi;
import de.setsoftware.reviewtool.model.remarks.DummyMarker;
import de.setsoftware.reviewtool.model.remarks.FileLinePosition;
import de.setsoftware.reviewtool.model.remarks.FilePosition;
import de.setsoftware.reviewtool.model.remarks.GlobalPosition;
import de.setsoftware.reviewtool.model.remarks.IMarkerFactory;
import de.setsoftware.reviewtool.model.remarks.IReviewMarker;
import de.setsoftware.reviewtool.model.remarks.Position;
import de.setsoftware.reviewtool.model.remarks.RemarkType;
import de.setsoftware.reviewtool.model.remarks.ResolutionType;
import de.setsoftware.reviewtool.model.remarks.ReviewData;
import de.setsoftware.reviewtool.model.remarks.ReviewRemark;
import de.setsoftware.reviewtool.model.remarks.ReviewRemarkException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u0003H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/views/dialogs/CorrectSyntaxDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "errorMessage", "", "oldReviewData", "ticketKey", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "textField", "Lcom/intellij/ui/components/JBTextArea;", "createCenterPanel", "Ljavax/swing/JComponent;", "getDimensionServiceKey", "Companion", "IntelliJ-CoRT"})
public final class CorrectSyntaxDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String errorMessage;
    @Nullable
    private final String oldReviewData;
    private JBTextArea textField;

    private CorrectSyntaxDialog(String errorMessage, String oldReviewData, String ticketKey) {
        super(false);
        this.errorMessage = errorMessage;
        this.oldReviewData = oldReviewData;
        this.setTitle("Syntax error correction, " + ticketKey);
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)new JLabel(StringsKt.trimIndent((String)("\n    The review data has syntax errors. Please correct manually:\n    \n    " + this.errorMessage + "\n    "))), "North");
        this.textField = new JBTextArea(this.oldReviewData);
        JBTextArea jBTextArea = this.textField;
        if (jBTextArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textField");
            jBTextArea = null;
        }
        panel2.add((Component)jBTextArea, "Center");
        panel2.add((Component)new JLabel(StringsKt.trimIndent((String)("\n    Example:\n    \n    " + CorrectSyntaxDialog.Companion.createExampleData() + "\n    "))), "South");
        return panel2;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "de.set.reviewtool.correctSyntaxDialog";
    }

    public /* synthetic */ CorrectSyntaxDialog(String errorMessage, String oldReviewData, String ticketKey, DefaultConstructorMarker $constructor_marker) {
        this(errorMessage, oldReviewData, ticketKey);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002J$\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002\u00a8\u0006\u0013"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/views/dialogs/CorrectSyntaxDialog$Companion;", "", "<init>", "()V", "createExampleData", "", "newMarker", "Lde/setsoftware/reviewtool/model/remarks/IReviewMarker;", "getCurrentReviewDataParsed", "Lde/setsoftware/reviewtool/model/remarks/ReviewData;", "persistence", "Lde/setsoftware/reviewtool/model/ReviewStateManager;", "factory", "Lde/setsoftware/reviewtool/model/remarks/IMarkerFactory;", "canBeParsed", "reviewData", "allowCorrection", "errorMessage", "ticketKey", "IntelliJ-CoRT"})
    @SourceDebugExtension(value={"SMAP\nCorrectSyntaxDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CorrectSyntaxDialog.kt\nde/setsoftware/reviewtool/core/ui/intellij/views/dialogs/CorrectSyntaxDialog$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String createExampleData() {
            String string;
            try {
                PersistenceStub s = new PersistenceStub();
                InMemoryReviewDataCache c = new InMemoryReviewDataCache();
                ReviewStateManager p = new ReviewStateManager((IReviewDataCache)c, (ITicketConnector)s, (IUserInteraction)new StubUi("TEST-1234"));
                ReviewRemark r1 = ReviewRemark.create((IReviewMarker)this.newMarker(), (String)"TB", (Position)((Position)new GlobalPosition()), (String)"global review remark important to the reviewer", (RemarkType)RemarkType.MUST_FIX);
                r1.addComment("AUTHOR-ID", "Nachfrage");
                r1.setResolution(ResolutionType.QUESTION);
                p.saveRemark(r1);
                ReviewRemark r2 = ReviewRemark.create((IReviewMarker)this.newMarker(), (String)"TB", (Position)((Position)new FilePosition("FileName")), (String)"optional remark, with reference to a file", (RemarkType)RemarkType.CAN_FIX);
                r2.addComment("AUTHOR-ID", "comment to refuse fixing");
                r2.setResolution(ResolutionType.WONT_FIX);
                p.saveRemark(r2);
                ReviewRemark r3 = ReviewRemark.create((IReviewMarker)this.newMarker(), (String)"TB", (Position)((Position)new FileLinePosition("FileName", 42)), (String)"remark for direct fixing in a certain line", (RemarkType)RemarkType.ALREADY_FIXED);
                p.saveRemark(r3);
                s.setReviewRound(2);
                ReviewRemark r4 = ReviewRemark.create((IReviewMarker)this.newMarker(), (String)"TB", (Position)((Position)new GlobalPosition()), (String)"well done", (RemarkType)RemarkType.POSITIVE);
                p.saveRemark(r4);
                ReviewRemark r5 = ReviewRemark.create((IReviewMarker)this.newMarker(), (String)"TB", (Position)((Position)new GlobalPosition()), (String)"temporary marker for the reviewer", (RemarkType)RemarkType.TEMPORARY);
                p.saveRemark(r5);
                ReviewRemark r6 = ReviewRemark.create((IReviewMarker)this.newMarker(), (String)"TB", (Position)((Position)new GlobalPosition()), (String)"some other remark, e.g. 'part of the remarks have been communicated orally'", (RemarkType)RemarkType.OTHER);
                p.saveRemark(r6);
                string = p.getCurrentReviewData();
            }
            catch (ReviewRemarkException e) {
                throw new AssertionError((Object)e);
            }
            return string;
        }

        private final IReviewMarker newMarker() {
            return (IReviewMarker)new DummyMarker();
        }

        @Nullable
        public final ReviewData getCurrentReviewDataParsed(@NotNull ReviewStateManager persistence, @NotNull IMarkerFactory factory) {
            boolean hadError;
            String reviewData;
            block3: {
                String string;
                String string2;
                Intrinsics.checkNotNullParameter((Object)persistence, (String)"persistence");
                Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
                String string3 = persistence.getCurrentReviewData();
                if (string3 == null) {
                    return null;
                }
                reviewData = string3;
                String parseError = null;
                hadError = false;
                do {
                    String string4;
                    String it = string4 = this.canBeParsed(persistence, reviewData);
                    boolean bl = false;
                    parseError = it;
                    if (string4 == null) break block3;
                    hadError = true;
                    string2 = parseError;
                    Intrinsics.checkNotNull((Object)string2);
                    string = persistence.getTicketKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTicketKey(...)");
                } while ((reviewData = this.allowCorrection(string2, reviewData, string)) != null);
                return null;
            }
            if (hadError) {
                persistence.saveCurrentReviewData(reviewData);
            }
            return ReviewData.parse((Map)persistence.getReviewersForRounds(), (IMarkerFactory)factory, (String)reviewData);
        }

        private final String canBeParsed(ReviewStateManager persistence, String reviewData) {
            String string;
            try {
                ReviewData.parse((Map)persistence.getReviewersForRounds(), (IMarkerFactory)DummyMarker.FACTORY, (String)reviewData);
                string = null;
            }
            catch (RuntimeException e) {
                string = e.getMessage() == null ? e.toString() : e.getMessage();
            }
            return string;
        }

        private final String allowCorrection(String errorMessage, String reviewData, String ticketKey) {
            String string;
            CorrectSyntaxDialog dialog = new CorrectSyntaxDialog(errorMessage, reviewData, ticketKey, null);
            boolean ok = dialog.showAndGet();
            if (!ok) {
                string = null;
            } else {
                JBTextArea jBTextArea = dialog.textField;
                if (jBTextArea == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"textField");
                    jBTextArea = null;
                }
                string = jBTextArea.getText();
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

