/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.tourrestructuring.onestop;

import de.setsoftware.reviewtool.model.changestructure.ITourRestructuring;
import de.setsoftware.reviewtool.model.changestructure.Tour;
import de.setsoftware.reviewtool.tourrestructuring.onestop.MutableTour;
import java.util.ArrayList;
import java.util.List;

public class OneStopPerPartOfFileRestructuring
implements ITourRestructuring {
    public String getDescription() {
        return "merge all changes in the same part of a file into one stop";
    }

    public List<? extends Tour> restructure(List<Tour> originalTours) {
        if (originalTours.size() <= 1) {
            return null;
        }
        ArrayList<MutableTour> mutableTours = new ArrayList<MutableTour>();
        for (Tour t : originalTours) {
            mutableTours.add(new MutableTour(t));
        }
        boolean didSomething = this.resolveToursIfFullyResolvable(mutableTours);
        if (didSomething |= this.mergeAllMergeableStops(mutableTours)) {
            return MutableTour.toTours(mutableTours);
        }
        return null;
    }

    private boolean resolveToursIfFullyResolvable(List<MutableTour> mutableTours) {
        boolean didSomething = false;
        int i = 0;
        while (i < mutableTours.size()) {
            MutableTour curTour = mutableTours.get(i);
            if (curTour.canBeResolvedCompletely(mutableTours, i)) {
                curTour.resolve(mutableTours, i);
                assert (mutableTours.get(i).isEmpty());
                mutableTours.remove(i);
                --i;
                didSomething = true;
            }
            ++i;
        }
        return didSomething;
    }

    private boolean mergeAllMergeableStops(List<MutableTour> mutableTours) {
        boolean didSomething = false;
        int i = 0;
        while (i < mutableTours.size()) {
            MutableTour curTour = mutableTours.get(i);
            didSomething |= curTour.resolve(mutableTours, i);
            if (curTour.isEmpty()) {
                mutableTours.remove(i);
                --i;
            }
            ++i;
        }
        return didSomething;
    }
}

