/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering;

import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.model.changestructure.Stop;
import de.setsoftware.reviewtool.model.changestructure.Tour;
import de.setsoftware.reviewtool.model.changestructure.TourElement;
import de.setsoftware.reviewtool.ordering.ChangePart;
import de.setsoftware.reviewtool.ordering.HierarchyExplicitness;
import de.setsoftware.reviewtool.ordering.OrderingInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TourHierarchyBuilder {
    private final List<Stop> stops = new ArrayList<Stop>();
    private final Map<Stop, Integer> indexMap;
    private TreeNode firstRoot;

    public TourHierarchyBuilder(List<ChangePart> sorted) {
        for (ChangePart c : sorted) {
            this.stops.addAll(c.getStops());
        }
        Logger.info((String)("stops in TourHierarchyBuilder: " + this.stops.size() + " (" + sorted.size() + " change parts)"));
        this.indexMap = new HashMap<Stop, Integer>();
        TreeNode cur = null;
        int i = this.stops.size() - 1;
        while (i >= 0) {
            cur = new TreeNode(i, i, cur, null, null);
            this.indexMap.put(this.stops.get(i), i);
            --i;
        }
        this.firstRoot = cur;
    }

    public void createSubtourIfPossible(OrderingInfo o) {
        if (o.getExplicitness() == HierarchyExplicitness.NONE) {
            return;
        }
        int minIndex = Integer.MAX_VALUE;
        int maxIndex = Integer.MIN_VALUE;
        int stopCountInMatchSet = 0;
        for (ChangePart c : o.getMatchSet().getChangeParts()) {
            for (Stop s : c.getStops()) {
                minIndex = Math.min(minIndex, this.indexMap.get(s));
                maxIndex = Math.max(maxIndex, this.indexMap.get(s));
            }
            stopCountInMatchSet += c.getStops().size();
        }
        if (maxIndex - minIndex != stopCountInMatchSet - 1) {
            return;
        }
        TreeNode upper = null;
        TreeNode prev = null;
        TreeNode cur = this.firstRoot;
        while (cur != null) {
            if (cur.minIndex == minIndex && cur.maxIndex == maxIndex) {
                if (o.getExplicitness() == HierarchyExplicitness.ALWAYS) {
                    TreeNode newNode = new TreeNode(minIndex, maxIndex, cur.sibling, cur, o.getDescription());
                    cur.sibling = null;
                    if (prev != null) {
                        prev.sibling = newNode;
                    } else if (upper != null) {
                        upper.firstChild = newNode;
                    } else {
                        this.firstRoot = newNode;
                    }
                }
                return;
            }
            if (cur.minIndex <= minIndex && cur.maxIndex >= maxIndex) {
                upper = cur;
                prev = null;
                cur = cur.firstChild;
                continue;
            }
            if (cur.minIndex == minIndex) {
                TreeNode end = this.findSiblingWithMaxIndex(cur, maxIndex);
                if (end == null) {
                    return;
                }
                if (prev == null && end.sibling == null && o.getExplicitness() != HierarchyExplicitness.ALWAYS) {
                    return;
                }
                TreeNode newNode = new TreeNode(minIndex, maxIndex, end.sibling, cur, o.getDescription());
                end.sibling = null;
                if (prev != null) {
                    prev.sibling = newNode;
                } else if (upper != null) {
                    upper.firstChild = newNode;
                } else {
                    this.firstRoot = newNode;
                }
                return;
            }
            prev = cur;
            cur = cur.sibling;
        }
    }

    private TreeNode findSiblingWithMaxIndex(TreeNode node, int maxIndex) {
        TreeNode cur = node;
        while (cur != null) {
            if (cur.maxIndex == maxIndex) {
                return cur;
            }
            cur = cur.sibling;
        }
        return null;
    }

    public List<? extends TourElement> getTopmostElements() {
        return this.toTourElements(this.firstRoot);
    }

    private List<? extends TourElement> toTourElements(TreeNode node) {
        ArrayList<Object> ret = new ArrayList<Object>();
        TreeNode cur = node;
        while (cur != null) {
            if (cur.isLeaf()) {
                ret.add((TourElement)this.stops.get(cur.minIndex));
            } else {
                ret.add(new Tour(cur.description, this.toTourElements(cur.firstChild)));
            }
            cur = cur.sibling;
        }
        return ret;
    }

    private static final class TreeNode {
        private final int minIndex;
        private final int maxIndex;
        private TreeNode sibling;
        private TreeNode firstChild;
        private final String description;

        public TreeNode(int minIndex, int maxIndex, TreeNode sibling, TreeNode firstChild, String description) {
            this.minIndex = minIndex;
            this.maxIndex = maxIndex;
            this.sibling = sibling;
            this.firstChild = firstChild;
            this.description = description;
        }

        public boolean isLeaf() {
            return this.firstChild == null;
        }
    }
}

