/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering;

import com.github.javaparser.Position;
import com.github.javaparser.ast.nodeTypes.NodeWithRange;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.changestructure.Stop;
import de.setsoftware.reviewtool.ordering.ChangePart;
import java.util.ArrayList;
import java.util.List;

class LineRangeMap {
    private final List<ChangePart> parts;

    public LineRangeMap(List<ChangePart> parts) {
        this.parts = parts;
    }

    public List<ChangePart> getOverlappingParts(NodeWithRange<?> m) {
        ArrayList<ChangePart> ret = new ArrayList<ChangePart>();
        for (ChangePart p : this.parts) {
            if (!this.overlaps(p, m)) continue;
            ret.add(p);
        }
        return ret;
    }

    private boolean overlaps(ChangePart p, NodeWithRange<?> m) {
        for (Stop s : p.getStops()) {
            if (!this.overlaps(s, m)) continue;
            return true;
        }
        return false;
    }

    private boolean overlaps(Stop s, NodeWithRange<?> m) {
        IFragment fragment = s.getOriginalMostRecentFragment();
        int startLineS = fragment.getFrom().getLine();
        int endLineS = fragment.getTo().getLine() - (fragment.getTo().getColumn() > 1 ? 0 : 1);
        int startLineM = ((Position)m.getBegin().get()).line;
        int endLineM = ((Position)m.getEnd().get()).line;
        return endLineS >= startLineM && endLineM >= startLineS;
    }
}

