/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ticketconnectors.jira;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.base.Util;
import de.setsoftware.reviewtool.model.EndTransition;
import de.setsoftware.reviewtool.model.ITicketConnector;
import de.setsoftware.reviewtool.model.ITicketData;
import de.setsoftware.reviewtool.model.TicketInfo;
import de.setsoftware.reviewtool.model.TicketLinkSettings;
import de.setsoftware.reviewtool.ticketconnectors.jira.BearerTokenProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JiraPersistence
implements ITicketConnector {
    private final String url;
    private final String reviewFieldName;
    private final String user;
    private final String password;
    private final String reviewStateName;
    private final String implementationStateName;
    private final String readyForReviewStateName;
    private final String rejectedStateName;
    private final String doneStateName;
    private StateIds stateIds;
    private final Map<String, String> filtersForReview;
    private final Map<String, String> filtersForFixing;
    private String reviewFieldId;
    private final TicketLinkSettings linkSettings;
    private final File cookiesFile;
    private final String oauthIssuer;
    private final String oauthAudience;
    private final String oauthClientID;
    private final String oauthClientSecret;

    public JiraPersistence(String url, String reviewFieldName, String reviewState, String implementationState, String readyForReviewState, String rejectedState, String doneState, String user, String password, TicketLinkSettings linkSettings, File cookiesFile, String oauthIssuer, String oauthAudience, String oauthClientID, String oauthClientSecret) {
        this.url = url;
        this.reviewFieldName = reviewFieldName;
        this.user = user;
        this.password = password;
        this.cookiesFile = cookiesFile;
        this.reviewStateName = reviewState;
        this.implementationStateName = implementationState;
        this.readyForReviewStateName = readyForReviewState;
        this.rejectedStateName = rejectedState;
        this.doneStateName = doneState;
        this.filtersForReview = new LinkedHashMap<String, String>();
        this.filtersForFixing = new LinkedHashMap<String, String>();
        this.linkSettings = linkSettings;
        this.oauthAudience = oauthAudience;
        this.oauthClientID = oauthClientID;
        this.oauthClientSecret = oauthClientSecret;
        this.oauthIssuer = !(oauthAudience.isEmpty() || oauthClientID.isEmpty() || oauthClientSecret.isEmpty()) ? (oauthIssuer.isEmpty() ? this.ensureSlashAtEnd(url) : this.ensureSlashAtEnd(oauthIssuer)) : null;
    }

    private String ensureSlashAtEnd(String url) {
        return url.endsWith("/") ? url : String.valueOf(url) + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateIds sids() {
        if (this.stateIds != null) {
            return this.stateIds;
        }
        JiraPersistence jiraPersistence = this;
        synchronized (jiraPersistence) {
            if (this.stateIds == null) {
                this.stateIds = new StateIds();
            }
            return this.stateIds;
        }
    }

    private JsonArray loadStates() {
        String getUrl = String.format("%s/rest/api/latest/status?%s", this.url, this.getAuthParams());
        return this.performGet(getUrl).asArray();
    }

    public void saveReviewData(String ticketKey, String newData) {
        String putUrl = String.format("%s/rest/api/latest/issue/%s?%s", this.url, ticketKey, this.getAuthParams());
        JsonObject fields = new JsonObject();
        fields.add(this.getReviewFieldId(), newData);
        JsonObject json = new JsonObject();
        json.add("fields", (JsonValue)fields);
        this.performPut(putUrl, json);
    }

    private boolean isToReview(JsonValue v) {
        JsonArray items = v.asObject().get("items").asArray();
        for (JsonValue item : items) {
            JsonObject io = item.asObject();
            if (!io.get("field").asString().equals("status") || !io.get("to").asString().equals(this.sids().reviewStateId)) continue;
            return true;
        }
        return false;
    }

    private String getToUser(JsonValue v) {
        JsonValue author = v.asObject().get("author");
        JsonValue authorName = author == null ? null : author.asObject().get("name");
        return authorName == null ? "" : authorName.toString();
    }

    private JsonArray getHistories(JsonObject ticket) {
        return ticket.get("changelog").asObject().get("histories").asArray();
    }

    public ITicketData loadTicket(String ticketKey) {
        JsonObject object = (JsonObject)this.performGet(String.valueOf(this.url) + "/rest/api/latest/issue/" + ticketKey + "?fields=" + this.getReviewFieldId() + "&expand=changelog" + this.getAuthParams());
        if (object.get("key") == null) {
            return null;
        }
        return new JiraTicket(object);
    }

    public Set<String> getFilterNamesForReview() {
        return this.filtersForReview.keySet();
    }

    public Set<String> getFilterNamesForFixing() {
        return this.filtersForFixing.keySet();
    }

    public List<TicketInfo> getTicketsForFilter(String filterName) {
        if (this.filtersForReview.containsKey(filterName)) {
            return this.queryTickets(this.filtersForReview.get(filterName));
        }
        return this.queryTickets(this.filtersForFixing.get(filterName));
    }

    public void addFilter(String name, String jql, boolean forReview) {
        if (forReview) {
            this.filtersForReview.put(name, jql);
        } else {
            this.filtersForFixing.put(name, jql);
        }
    }

    private List<TicketInfo> queryTickets(String jql) {
        try {
            String searchUrl = String.format("%s/rest/api/latest/search?maxResults=200&fields=summary,components,status,parent&expand=changelog&jql=%s%s", this.url, URLEncoder.encode(jql, "UTF-8"), this.getAuthParams());
            JsonObject result = this.performGet(searchUrl).asObject();
            ArrayList<TicketInfo> ret = new ArrayList<TicketInfo>();
            for (JsonValue issue : result.get("issues").asArray()) {
                ret.add(this.mapTicket(issue.asObject()));
            }
            return ret;
        }
        catch (UnsupportedEncodingException e) {
            throw new ReviewtoolException((Exception)e);
        }
    }

    private TicketInfo mapTicket(JsonObject ticket) {
        JsonValue parent = ticket.get("fields").asObject().get("parent");
        return new TicketInfo(ticket.get("key").asString(), ticket.get("fields").asObject().get("summary").asString(), ticket.get("fields").asObject().get("status").asObject().get("name").asString(), this.getPreviousStatus(ticket), this.formatComponents(ticket.get("fields").asObject().get("components").asArray()), parent == null ? null : parent.asObject().get("fields").asObject().get("summary").asString(), this.getReviewers(ticket), this.getTimeOfTransferToCurrentStatus(ticket));
    }

    private Set<String> getReviewers(JsonObject ticket) {
        LinkedHashSet<String> reviewers = new LinkedHashSet<String>();
        JsonArray histories = this.getHistories(ticket);
        for (JsonValue v : histories) {
            String reviewer;
            if (!this.isToReview(v) || (reviewer = this.getToUser(v)).isEmpty()) continue;
            reviewers.add(reviewer.toUpperCase());
        }
        return reviewers;
    }

    private String getPreviousStatus(JsonObject ticket) {
        String prevStatus = "";
        JsonArray histories = this.getHistories(ticket);
        for (JsonValue v : histories) {
            String fromStatus = this.getFromStatus(v);
            if (fromStatus == null) continue;
            prevStatus = fromStatus;
        }
        return prevStatus;
    }

    private Date getTimeOfTransferToCurrentStatus(JsonObject ticket) {
        Date ret = new Date(0L);
        JsonArray histories = this.getHistories(ticket);
        for (JsonValue v : histories) {
            String fromStatus = this.getFromStatus(v);
            if (fromStatus == null) continue;
            ret = (Date)Util.max((Comparable)ret, (Comparable)this.getTimeOfHistoryItem(v));
        }
        return ret;
    }

    private Date getTimeOfHistoryItem(JsonValue v) {
        String dateString = v.asObject().get("created").asString();
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX").parse(dateString);
        }
        catch (java.text.ParseException e) {
            throw new ReviewtoolException((Exception)e);
        }
    }

    private String getFromStatus(JsonValue v) {
        JsonArray items = v.asObject().get("items").asArray();
        for (JsonValue item : items) {
            JsonObject io = item.asObject();
            if (!io.get("field").asString().equals("status")) continue;
            return io.get("fromString").asString();
        }
        return null;
    }

    private String formatComponents(JsonArray components) {
        StringBuilder b = new StringBuilder();
        for (JsonValue v : components) {
            if (b.length() != 0) {
                b.append(", ");
            }
            b.append(v.asObject().get("name"));
        }
        return b.toString();
    }

    private String getReviewFieldId() {
        if (this.reviewFieldId != null) {
            return this.reviewFieldId;
        }
        this.reviewFieldId = this.getIdForName(this.reviewFieldName);
        return this.reviewFieldId;
    }

    private String getIdForName(String name) {
        JsonArray fields = this.performGet(String.valueOf(this.url) + "/rest/api/latest/field/").asArray();
        for (JsonValue o : fields) {
            if (!o.asObject().get("name").asString().equals(name)) continue;
            return o.asObject().get("id").asString();
        }
        throw new ReviewtoolException("found no id for name " + name);
    }

    public JsonValue performGet(String searchUrl) {
        StringBuilder b = new StringBuilder();
        try {
            this.communicate(searchUrl, "GET", null, input -> {
                try {
                    int ch;
                    InputStreamReader reader = new InputStreamReader((InputStream)input, "UTF-8");
                    while ((ch = reader.read()) >= 0) {
                        b.append((char)ch);
                    }
                }
                catch (IOException e) {
                    throw new ReviewtoolException((Exception)e);
                }
            });
        }
        catch (IOException e) {
            throw new ReviewtoolException((Exception)e);
        }
        String data = b.toString();
        try {
            return Json.parse((String)data);
        }
        catch (ParseException e) {
            throw new ReviewtoolException("exception parsing: " + data, (Exception)((Object)e));
        }
    }

    private String getAuthParams() {
        try {
            return String.format("&os_username=%s&os_password=%s", URLEncoder.encode(this.user, "UTF-8"), URLEncoder.encode(this.password, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ReviewtoolException((Exception)e);
        }
    }

    private void performPut(String putUrl, JsonObject json) {
        try {
            this.communicate(putUrl, "PUT", json.toString(), s -> {});
        }
        catch (IOException e) {
            throw new ReviewtoolException((Exception)e);
        }
    }

    private void performPost(String postUrl, JsonObject json) {
        try {
            this.communicate(postUrl, "POST", json.toString(), s -> {});
        }
        catch (IOException e) {
            throw new ReviewtoolException((Exception)e);
        }
    }

    private void communicate(String url, String method, String data, Consumer<InputStream> resultConsumer) throws IOException {
        Logger.debug((String)("communicate to JIRA: " + this.trimArgs(url)));
        HttpURLConnection c = (HttpURLConnection)new URL(url).openConnection();
        c.setRequestMethod(method);
        c.addRequestProperty("Content-Type", "application/json");
        String cookies = this.loadCookies();
        if (!cookies.isEmpty()) {
            c.setRequestProperty("Cookie", cookies);
        }
        c.setDoOutput(data != null);
        c.connect();
        if (data != null) {
            try (OutputStream outputStream = c.getOutputStream();){
                outputStream.write(data.getBytes("UTF-8"));
            }
        }
        for (Map.Entry<String, List<String>> header : c.getHeaderFields().entrySet()) {
            if (!"Set-Cookie".equalsIgnoreCase(header.getKey())) continue;
            this.setCookies(header.getValue());
        }
        try {
            try {
                InputStream s = c.getInputStream();
                resultConsumer.accept(s);
                s.close();
            }
            catch (IOException e) {
                this.flushErrorStream(c);
                throw e;
            }
        }
        finally {
            c.disconnect();
        }
    }

    private String trimArgs(String url2) {
        int end = url2.indexOf(63);
        return end < 0 ? url2 : url2.substring(0, end);
    }

    private void setCookies(List<String> cookies) throws IOException {
        if (this.cookiesFile == null) {
            return;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (this.cookiesFile.exists()) {
            Files.lines(this.cookiesFile.toPath(), Charset.forName("UTF-8")).forEach(line -> this.putSplitAtEqualsSign((Map<String, String>)map, (String)line));
        }
        for (String cookie : cookies) {
            int semiIndex = cookie.indexOf(59);
            String keyAndValue = semiIndex >= 0 ? cookie.substring(0, semiIndex) : cookie;
            this.putSplitAtEqualsSign(map, keyAndValue);
        }
        StringBuilder content = new StringBuilder();
        for (Map.Entry e : map.entrySet()) {
            content.append((String)e.getKey()).append('=').append((String)e.getValue()).append('\n');
        }
        Files.write(this.cookiesFile.toPath(), content.toString().getBytes("UTF-8"), new OpenOption[0]);
    }

    private void putSplitAtEqualsSign(Map<String, String> map, String keyAndValue) {
        if (keyAndValue.isEmpty()) {
            return;
        }
        int equalsIndex = keyAndValue.indexOf(61);
        map.put(keyAndValue.substring(0, equalsIndex), keyAndValue.substring(equalsIndex + 1));
    }

    private String loadCookies() throws IOException {
        if (this.cookiesFile == null || !this.cookiesFile.exists()) {
            Logger.debug((String)("using no cookies " + this.cookiesFile));
            return this.createBaererTokenCookie();
        }
        Stream<String> cookies = Stream.concat(Files.lines(this.cookiesFile.toPath(), Charset.forName("UTF-8")), Stream.of(this.createBaererTokenCookie()));
        return cookies.collect(Collectors.joining("; "));
    }

    private String createBaererTokenCookie() throws IOException {
        if (this.oauthIssuer == null) {
            Logger.debug((String)"using no bearer token");
            return "";
        }
        Logger.debug((String)("using bearer token from issuer " + this.oauthIssuer));
        String bearerToken = BearerTokenProvider.createBearerToken(this.oauthIssuer, this.oauthAudience, this.oauthClientID, this.oauthClientSecret);
        return "bearertoken=" + bearerToken;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void flushErrorStream(HttpURLConnection c) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            InputStream s = c.getErrorStream();
            try {
                if (s == null) {
                    System.err.print("cannot flush, error stream is null");
                    return;
                }
                while (true) {
                    int r;
                    if ((r = s.read()) < 0) {
                        return;
                    }
                    System.err.write(r);
                }
            }
            finally {
                if (s == null) return;
                s.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public void startReviewing(String ticketKey) {
        this.performTransitionIfPossible(ticketKey, this.sids().reviewStateId);
    }

    public void startFixing(String ticketKey) {
        this.performTransitionIfPossible(ticketKey, this.sids().implementationStateId);
    }

    public void changeStateToReadyForReview(String ticketKey) {
        this.performTransitionIfPossible(ticketKey, this.sids().readyForReviewStateId);
    }

    public List<EndTransition> getPossibleTransitionsForReviewEnd(String ticket) {
        String getUrl = String.format("%s/rest/api/latest/issue/%s/transitions?%s", this.url, ticket, this.getAuthParams());
        JsonObject result = this.performGet(getUrl).asObject();
        ArrayList<EndTransition> ret = new ArrayList<EndTransition>();
        for (JsonValue curValue : result.get("transitions").asArray()) {
            JsonObject transition = curValue.asObject();
            String transitionTarget = transition.get("to").asObject().get("id").asString();
            ret.add(new EndTransition(transition.get("name").asString(), transition.get("id").asString(), this.determineTransitionType(transitionTarget)));
        }
        return ret;
    }

    private EndTransition.Type determineTransitionType(String transitionTargetId) {
        if (this.sids().doneStateId.equals(transitionTargetId)) {
            return EndTransition.Type.OK;
        }
        if (this.sids().rejectedStateId.equals(transitionTargetId)) {
            return EndTransition.Type.REJECTION;
        }
        return EndTransition.Type.UNKNOWN;
    }

    public void changeStateAtReviewEnd(String ticketKey, EndTransition transition) {
        this.performTransition(ticketKey, transition.getInternalName());
    }

    private void performTransitionIfPossible(String ticketKey, String targetStateId) {
        TreeSet<String> possibleTransitions = new TreeSet<String>();
        String transition = this.getTransitionId(ticketKey, targetStateId, possibleTransitions);
        if (transition == null) {
            Logger.info((String)("Could not transition " + ticketKey + " to " + targetStateId + ". Possible transitions: " + possibleTransitions));
        } else if (targetStateId.equals(this.getCurrentStatus(ticketKey))) {
            Logger.debug((String)("Did not transition, already in state " + targetStateId));
        } else {
            this.performTransition(ticketKey, transition);
        }
    }

    private String getCurrentStatus(String ticketKey) {
        String getUrl = String.format("%s/rest/api/latest/issue/%s?fields=status&%s", this.url, ticketKey, this.getAuthParams());
        JsonObject result = this.performGet(getUrl).asObject();
        return result.get("fields").asObject().get("status").asObject().get("id").asString();
    }

    private void performTransition(String ticket, String transitionId) {
        String postUrl = String.format("%s/rest/api/latest/issue/%s/transitions?%s", this.url, ticket, this.getAuthParams());
        JsonObject to = new JsonObject();
        to.add("id", transitionId);
        JsonObject command = new JsonObject();
        command.add("transition", (JsonValue)to);
        this.performPost(postUrl, command);
    }

    private String getTransitionId(String ticket, String targetStateName, Set<String> possibleTransitions) {
        String getUrl = String.format("%s/rest/api/latest/issue/%s/transitions?%s", this.url, ticket, this.getAuthParams());
        JsonObject result = this.performGet(getUrl).asObject();
        for (JsonValue curValue : result.get("transitions").asArray()) {
            JsonObject transition = curValue.asObject();
            String transitionTarget = transition.get("to").asObject().get("id").asString();
            possibleTransitions.add(transitionTarget);
            if (!targetStateName.equals(transitionTarget)) continue;
            return transition.get("id").asString();
        }
        return null;
    }

    public TicketLinkSettings getLinkSettings() {
        return this.linkSettings;
    }

    private final class JiraTicket
    implements ITicketData {
        private final JsonObject ticket;

        public JiraTicket(JsonObject object) {
            this.ticket = object;
        }

        public String getReviewData() {
            JsonValue reviewData = this.ticket.get("fields").asObject().get(JiraPersistence.this.getReviewFieldId());
            if (reviewData == null || reviewData.isNull()) {
                return "";
            }
            return reviewData.asString();
        }

        public String getReviewerForRound(int number) {
            JsonArray histories = JiraPersistence.this.getHistories(this.ticket);
            int count = 0;
            for (JsonValue v : histories) {
                if (!JiraPersistence.this.isToReview(v) || ++count != number) continue;
                return JiraPersistence.this.getToUser(v).toUpperCase();
            }
            return JiraPersistence.this.user.toUpperCase();
        }

        public Date getEndTimeForRound(int number) {
            JsonArray histories = JiraPersistence.this.getHistories(this.ticket);
            int count = 0;
            for (JsonValue v : histories) {
                if (!JiraPersistence.this.isToReview(v) || ++count != number) continue;
                return JiraPersistence.this.getTimeOfHistoryItem(v);
            }
            return new Date();
        }

        public int getCurrentRound() {
            JsonArray histories = JiraPersistence.this.getHistories(this.ticket);
            int count = 0;
            for (JsonValue v : histories) {
                if (!JiraPersistence.this.isToReview(v)) continue;
                ++count;
            }
            return count;
        }

        public TicketInfo getTicketInfo() {
            return (TicketInfo)JiraPersistence.this.queryTickets("key=" + this.getId()).get(0);
        }

        public String getId() {
            return this.ticket.get("key").asString();
        }
    }

    private final class StateIds {
        private final String reviewStateId;
        private final String implementationStateId;
        private final String readyForReviewStateId;
        private final String rejectedStateId;
        private final String doneStateId;

        public StateIds() {
            JsonArray states = JiraPersistence.this.loadStates();
            this.reviewStateId = this.getStateId(states, JiraPersistence.this.reviewStateName);
            this.implementationStateId = this.getStateId(states, JiraPersistence.this.implementationStateName);
            this.readyForReviewStateId = this.getStateId(states, JiraPersistence.this.readyForReviewStateName);
            this.rejectedStateId = this.getStateId(states, JiraPersistence.this.rejectedStateName);
            this.doneStateId = this.getStateId(states, JiraPersistence.this.doneStateName);
        }

        private String getStateId(JsonArray states, String stateName) {
            ArrayList<String> possibleNames = new ArrayList<String>();
            for (JsonValue v : states) {
                String name = v.asObject().get("name").asString();
                if (name.equals(stateName)) {
                    return v.asObject().get("id").asString();
                }
                possibleNames.add(name);
            }
            throw new ReviewtoolException("Status " + stateName + " not found in JIRA." + " Possible values: " + possibleNames);
        }
    }
}

