/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.svn;

import de.setsoftware.reviewtool.base.ComparableWrapper;
import de.setsoftware.reviewtool.base.IPartiallyComparable;
import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.base.ValueWrapper;
import de.setsoftware.reviewtool.changesources.svn.CachedLogEntry;
import de.setsoftware.reviewtool.changesources.svn.ISvnRepo;
import de.setsoftware.reviewtool.changesources.svn.SvnFileCache;
import de.setsoftware.reviewtool.changesources.svn.SvnRepositoryManager;
import de.setsoftware.reviewtool.diffalgorithms.DiffAlgorithmFactory;
import de.setsoftware.reviewtool.model.api.IMutableFileHistoryGraph;
import de.setsoftware.reviewtool.model.api.IRepoRevision;
import de.setsoftware.reviewtool.model.changestructure.AbstractRepository;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryGraph;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNRevision;

final class SvnRepo
extends AbstractRepository
implements ISvnRepo {
    private static final long serialVersionUID = 8792151363600093081L;
    private final java.io.File cacheDir;
    private final SVNRepository svnRepo;
    private final String id;
    private final SVNURL remoteUrl;
    private final String relPath;
    private final SvnFileCache fileCache;
    private final List<CachedLogEntry> entries;
    private IMutableFileHistoryGraph fileHistoryGraph;

    SvnRepo(SVNRepository svnRepo, SVNURL remoteUrl, java.io.File cacheDir) throws SVNException {
        this.cacheDir = cacheDir;
        this.svnRepo = svnRepo;
        this.id = svnRepo.getRepositoryUUID(true);
        this.remoteUrl = remoteUrl;
        this.fileCache = new SvnFileCache(this.svnRepo);
        this.entries = new ArrayList<CachedLogEntry>();
        this.fileHistoryGraph = new FileHistoryGraph(DiffAlgorithmFactory.createDefault());
        SVNURL repositoryRoot = svnRepo.getRepositoryRoot(true);
        this.relPath = !repositoryRoot.equals((Object)remoteUrl) ? remoteUrl.toString().substring(repositoryRoot.toString().length()) : "";
    }

    @Override
    public SVNURL getRemoteUrl() {
        return this.remoteUrl;
    }

    @Override
    public List<CachedLogEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    @Override
    public void appendNewEntries(Collection<CachedLogEntry> newEntries) {
        this.entries.addAll(newEntries);
    }

    @Override
    public java.io.File getCacheFilePath() {
        return new java.io.File(this.cacheDir, "svnlog-" + SvnRepo.encodeString(this.remoteUrl.toString()) + ".cache");
    }

    public String getId() {
        return this.id;
    }

    public byte[] getFileContents(String path, IRepoRevision<?> revision) throws SVNException {
        return this.fileCache.getFileContents(path, (Long)ComparableWrapper.unwrap((IPartiallyComparable)revision.getId()));
    }

    public Set<File> getFiles(final String path, IRepoRevision<?> revision) {
        final LinkedHashSet<File> result = new LinkedHashSet<File>();
        final long revisionNumber = (Long)ComparableWrapper.unwrap((IPartiallyComparable)revision.getId());
        ISVNReporterBaton reporter = new ISVNReporterBaton(){

            public void report(ISVNReporter reporter) throws SVNException {
                reporter.setPath("", null, revisionNumber, SVNDepth.INFINITY, true);
                reporter.finishReport();
            }
        };
        ISVNEditor editor = new ISVNEditor(){

            public void abortEdit() {
            }

            public void absentDir(String path2) {
            }

            public void absentFile(String path2) {
            }

            public void addFile(String filePath, String copyFromPath, long copyFromRevision) {
                result.add(new File(path.isEmpty() ? filePath : String.valueOf(path) + "/" + filePath));
            }

            public SVNCommitInfo closeEdit() {
                return null;
            }

            public void closeFile(String path2, String textChecksum) {
            }

            public void deleteEntry(String path2, long revision) {
            }

            public void openFile(String path2, long revision) {
            }

            public void targetRevision(long revision) {
            }

            public void applyTextDelta(String path2, String baseChecksum) {
            }

            public OutputStream textDeltaChunk(String path2, SVNDiffWindow diffWindow) {
                return null;
            }

            public void textDeltaEnd(String path2) {
            }

            public void addDir(String path2, String copyFromPath, long copyFromRevision) {
            }

            public void changeDirProperty(String name, SVNPropertyValue value) {
            }

            public void changeFileProperty(String path2, String propertyName, SVNPropertyValue propertyValue) {
            }

            public void closeDir() {
            }

            public void openDir(String path2, long revision) {
            }

            public void openRoot(long revision) {
            }
        };
        try {
            SVNRepository repo = SvnRepositoryManager.getInstance().getTemporaryRepo(this.svnRepo.getRepositoryRoot(false), path);
            repo.status(revisionNumber, null, SVNDepth.INFINITY, reporter, editor);
        }
        catch (SVNException e) {
            Logger.warn((String)("Error while collecting files for directory " + path + "@" + revisionNumber), (Throwable)e);
        }
        return result;
    }

    @Override
    public IMutableFileHistoryGraph getFileHistoryGraph() {
        return this.fileHistoryGraph;
    }

    @Override
    public void setFileHistoryGraph(IMutableFileHistoryGraph fileHistoryGraph) {
        this.fileHistoryGraph = fileHistoryGraph;
    }

    public String toString() {
        return this.remoteUrl.toString();
    }

    @Override
    public void getLog(long startRevision, ISVNLogEntryHandler handler) throws SVNException {
        this.svnRepo.log(null, startRevision, this.svnRepo.getLatestRevision(), true, false, 0L, false, new String[0], handler);
    }

    @Override
    public long getLatestRevision() throws SVNException {
        final ValueWrapper latestRevision = new ValueWrapper((Object)SVNRevision.UNDEFINED.getNumber());
        ISVNLogEntryHandler handler = new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) {
                latestRevision.setValue((Object)logEntry.getRevision());
            }
        };
        this.svnRepo.log(null, this.svnRepo.getLatestRevision(), 0L, false, true, 1L, false, new String[0], handler);
        return (Long)latestRevision.get();
    }

    @Override
    public String getRelativePath() {
        return this.relPath;
    }

    private static String encodeString(String s) {
        return Base64.getUrlEncoder().encodeToString(s.getBytes());
    }

    private Object writeReplace() {
        return new SvnRepoRef(this.remoteUrl);
    }

    @Override
    public void clearCache() {
        this.getCacheFilePath().delete();
        this.setFileHistoryGraph((IMutableFileHistoryGraph)new FileHistoryGraph(DiffAlgorithmFactory.createDefault()));
        this.entries.clear();
    }

    private static final class File
    implements ISvnRepo.File {
        private final String path;

        private File(String path) {
            this.path = path;
        }

        @Override
        public String getName() {
            return this.path;
        }

        public String toString() {
            return this.path;
        }
    }

    private static final class SvnRepoRef
    implements Serializable {
        private static final long serialVersionUID = 8155878129812235537L;
        private final String remoteUrl;

        SvnRepoRef(SVNURL remoteUrl) {
            this.remoteUrl = remoteUrl.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                SvnRepo repo = SvnRepositoryManager.getInstance().getRepo(SVNURL.parseURIEncoded((String)this.remoteUrl));
                if (repo == null) {
                    throw new InvalidObjectException("No repository found at " + this.remoteUrl);
                }
                return repo;
            }
            catch (SVNException e) {
                InvalidObjectException ex = new InvalidObjectException("Problem while creating URL for " + this.remoteUrl);
                ex.initCause(e);
                throw ex;
            }
        }
    }
}

