/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.Multimap;
import de.setsoftware.reviewtool.base.PartialOrderAlgorithms;
import de.setsoftware.reviewtool.model.api.IDiffAlgorithm;
import de.setsoftware.reviewtool.model.api.IFileHistoryEdge;
import de.setsoftware.reviewtool.model.api.IFileHistoryNode;
import de.setsoftware.reviewtool.model.api.IMutableFileHistoryGraph;
import de.setsoftware.reviewtool.model.api.IRevision;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.changestructure.AbstractFileHistoryGraph;
import de.setsoftware.reviewtool.model.changestructure.ChangestructureFactory;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryNode;
import de.setsoftware.reviewtool.model.changestructure.ProxyableFileHistoryEdge;
import de.setsoftware.reviewtool.model.changestructure.ProxyableFileHistoryNode;
import de.setsoftware.reviewtool.model.changestructure.UnknownRevision;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class FileHistoryGraph
extends AbstractFileHistoryGraph
implements IMutableFileHistoryGraph {
    private static final long serialVersionUID = -1211314455688759596L;
    private final IDiffAlgorithm diffAlgorithm;
    private final Multimap<String, ProxyableFileHistoryNode> index;
    private final Multimap<IRevisionedFile, IFileHistoryNode> incompleteFlowStarts;

    public FileHistoryGraph(IDiffAlgorithm diffAlgorithm) {
        this.diffAlgorithm = diffAlgorithm;
        this.index = new Multimap();
        this.incompleteFlowStarts = new Multimap();
    }

    @Override
    public final synchronized Set<String> getPaths() {
        return this.index.keySet();
    }

    @Override
    public final synchronized void addAddition(String path, IRevision revision) {
        IRevisionedFile file = ChangestructureFactory.createFileInRevision(path, revision);
        ProxyableFileHistoryNode node = this.getOrCreateConnectedNode(file, IFileHistoryNode.Type.ADDED);
        if (node.getType().equals((Object)IFileHistoryNode.Type.DELETED)) {
            node.makeReplaced();
        } else if (node.getType().equals((Object)IFileHistoryNode.Type.UNCONFIRMED)) {
            node.makeAdded();
        }
    }

    @Override
    public final synchronized void addChange(String path, IRevision revision, Set<? extends IRevision> ancestorRevisions) {
        assert (!ancestorRevisions.isEmpty());
        IRevisionedFile file = ChangestructureFactory.createFileInRevision(path, revision);
        ProxyableFileHistoryNode node = this.getOrCreateUnconnectedNode(file, IFileHistoryNode.Type.CHANGED);
        assert (!node.getType().equals((Object)IFileHistoryNode.Type.DELETED));
        if (this.hasOnlyDummyAncestor(node)) {
            ArrayList<? extends ProxyableFileHistoryEdge> arrayList = new ArrayList<ProxyableFileHistoryEdge>(node.getAncestors());
            for (ProxyableFileHistoryEdge proxyableFileHistoryEdge : arrayList) {
                node.removeAncestor(proxyableFileHistoryEdge);
            }
        }
        if (node.isRoot()) {
            for (IRevision iRevision : ancestorRevisions) {
                IRevisionedFile prevFile = ChangestructureFactory.createFileInRevision(path, iRevision);
                ProxyableFileHistoryNode ancestor = this.getOrCreateConnectedNode(prevFile, IFileHistoryNode.Type.UNCONFIRMED);
                ancestor.addDescendant(node, IFileHistoryEdge.Type.NORMAL);
            }
        }
        if (node.getType().equals((Object)IFileHistoryNode.Type.UNCONFIRMED)) {
            node.makeConfirmed();
        }
    }

    private boolean hasOnlyDummyAncestor(ProxyableFileHistoryNode node) {
        return node.getAncestors().size() == 1 && node.getAncestors().iterator().next().getAncestor().getFile().getRevision() instanceof UnknownRevision;
    }

    @Override
    public final synchronized void addDeletion(String path, IRevision revision) {
        IRevisionedFile file = ChangestructureFactory.createFileInRevision(path, revision);
        ProxyableFileHistoryNode node = this.getOrCreateConnectedNode(file, IFileHistoryNode.Type.CHANGED);
        node.makeDeleted();
    }

    @Override
    public final synchronized void addCopy(String pathFrom, IRevision revisionFrom, String pathTo, IRevision revisionTo) {
        IRevisionedFile fileFrom = ChangestructureFactory.createFileInRevision(pathFrom, revisionFrom);
        IRevisionedFile fileTo = ChangestructureFactory.createFileInRevision(pathTo, revisionTo);
        ProxyableFileHistoryNode fromNode = this.getOrCreateConnectedNode(fileFrom, IFileHistoryNode.Type.UNCONFIRMED);
        ProxyableFileHistoryNode toNode = this.getOrCreateUnconnectedNode(fileTo, IFileHistoryNode.Type.CHANGED);
        if (toNode.getType().equals((Object)IFileHistoryNode.Type.DELETED)) {
            toNode.makeReplaced();
        } else if (toNode.getType().equals((Object)IFileHistoryNode.Type.UNCONFIRMED)) {
            toNode.makeConfirmed();
        }
        fromNode.addDescendant(toNode, IFileHistoryEdge.Type.COPY);
    }

    private ProxyableFileHistoryNode getOrCreateConnectedNode(IRevisionedFile file, IFileHistoryNode.Type nodeType) {
        return this.getOrCreateFileHistoryNode(file, nodeType, true);
    }

    private ProxyableFileHistoryNode getOrCreateUnconnectedNode(IRevisionedFile file, IFileHistoryNode.Type nodeType) {
        return this.getOrCreateFileHistoryNode(file, nodeType, false);
    }

    private ProxyableFileHistoryNode getOrCreateFileHistoryNode(IRevisionedFile file, IFileHistoryNode.Type nodeType, boolean connected) {
        assert (nodeType.equals((Object)IFileHistoryNode.Type.UNCONFIRMED) || nodeType.equals((Object)IFileHistoryNode.Type.ADDED) || nodeType.equals((Object)IFileHistoryNode.Type.CHANGED));
        ProxyableFileHistoryNode node = this.getNodeFor(file);
        if (node == null) {
            node = new FileHistoryNode(this, file, nodeType);
            this.index.put(file.getPath(), node);
            if (connected) {
                IRevisionedFile alphaFile;
                Set<Object> ancestors;
                Set<Object> set = ancestors = node.getType().equals((Object)IFileHistoryNode.Type.ADDED) ? new LinkedHashSet() : this.findAncestorsFor(file);
                if (ancestors.isEmpty() && !(alphaFile = ChangestructureFactory.createFileInRevision(file.getPath(), ChangestructureFactory.createUnknownRevision(file.getRepository()))).equals(file)) {
                    if (!node.getType().equals((Object)IFileHistoryNode.Type.ADDED)) {
                        this.incompleteFlowStarts.put(file, node);
                    }
                    ancestors.add(this.getOrCreateUnconnectedNode(alphaFile, IFileHistoryNode.Type.UNCONFIRMED));
                }
                if (!ancestors.isEmpty()) {
                    this.addNodeWithAncestors(node, ancestors, IFileHistoryEdge.Type.NORMAL);
                }
            }
        }
        assert (node != null);
        return node;
    }

    private void addNodeWithAncestors(ProxyableFileHistoryNode node, Set<ProxyableFileHistoryNode> ancestors, IFileHistoryEdge.Type edgeType) {
        for (ProxyableFileHistoryNode ancestor : ancestors) {
            if (ancestor.isConfirmed() && !node.isConfirmed()) {
                node.makeConfirmed();
            }
            if (node.isConfirmed() && !ancestor.isRoot()) {
                this.injectInteriorNode(ancestor, node);
            }
            ancestor.addDescendant(node, edgeType);
        }
    }

    private void injectInteriorNode(ProxyableFileHistoryNode ancestor, ProxyableFileHistoryNode interiorNode) {
        if (!ancestor.getFile().getPath().equals(interiorNode.getFile().getPath())) {
            return;
        }
        Iterator<? extends ProxyableFileHistoryEdge> it = ancestor.getDescendants().iterator();
        while (it.hasNext()) {
            ProxyableFileHistoryEdge descendantOfAncestorEdge = it.next();
            if (!descendantOfAncestorEdge.getType().equals((Object)IFileHistoryEdge.Type.NORMAL)) continue;
            ProxyableFileHistoryNode descendantOfAncestor = descendantOfAncestorEdge.getDescendant();
            it.remove();
            descendantOfAncestor.removeAncestor(descendantOfAncestorEdge);
            interiorNode.addDescendant(descendantOfAncestor, descendantOfAncestorEdge.getType());
            this.incompleteFlowStarts.removeValue(descendantOfAncestor.getFile(), descendantOfAncestor);
        }
    }

    @Override
    public final ProxyableFileHistoryNode getNodeFor(IRevisionedFile file) {
        List<ProxyableFileHistoryNode> nodesForKey = this.index.get(file.getPath());
        for (ProxyableFileHistoryNode node : nodesForKey) {
            if (!node.getFile().getRevision().equals(file.getRevision())) continue;
            return node;
        }
        return null;
    }

    public synchronized Set<ProxyableFileHistoryNode> findAncestorsFor(IRevisionedFile file) {
        List<ProxyableFileHistoryNode> nodesForKey = this.lookupFile(file);
        Map ancestorNodes = nodesForKey.stream().filter(node -> node.getFile().le(file) && !file.le(node.getFile())).collect(Collectors.toMap(IFileHistoryNode::getFile, Function.identity()));
        List<IRevisionedFile> maximalRevisions = PartialOrderAlgorithms.getAllMaximalElements(PartialOrderAlgorithms.topoSort(ancestorNodes.keySet()));
        Set<ProxyableFileHistoryNode> result = maximalRevisions.stream().map(ancestorFile -> (ProxyableFileHistoryNode)ancestorNodes.get(ancestorFile)).filter(node -> !node.getType().equals((Object)IFileHistoryNode.Type.DELETED)).collect(Collectors.toSet());
        return result;
    }

    @Override
    public final synchronized Set<IFileHistoryNode> getIncompleteFlowStarts() {
        LinkedHashSet<IFileHistoryNode> result = new LinkedHashSet<IFileHistoryNode>();
        for (IRevisionedFile file : this.incompleteFlowStarts.keySet()) {
            result.addAll(this.incompleteFlowStarts.get(file));
        }
        return result;
    }

    protected final List<ProxyableFileHistoryNode> lookupFile(IRevisionedFile file) {
        return this.index.get(file.getPath());
    }

    @Override
    public IDiffAlgorithm getDiffAlgorithm() {
        return this.diffAlgorithm;
    }

    public synchronized String toString() {
        return this.index.toString();
    }
}

