/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.model.api.IFileDiff;
import de.setsoftware.reviewtool.model.api.IFileHistoryEdge;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryEdge;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryGraph;
import de.setsoftware.reviewtool.model.changestructure.ProxyableFileHistoryEdge;
import de.setsoftware.reviewtool.model.changestructure.ProxyableFileHistoryNode;

final class FileHistoryEdgeProxy
extends ProxyableFileHistoryEdge {
    private static final long serialVersionUID = 5281364518525669034L;
    private final FileHistoryGraph graph;
    private final IRevisionedFile ancestorFile;
    private final IRevisionedFile descendantFile;
    private final IFileHistoryEdge.Type type;
    private transient FileHistoryEdge target;

    FileHistoryEdgeProxy(FileHistoryGraph graph, IRevisionedFile ancestorFile, IRevisionedFile descendantFile, IFileHistoryEdge.Type type) {
        this.graph = graph;
        this.ancestorFile = ancestorFile;
        this.descendantFile = descendantFile;
        this.type = type;
    }

    @Override
    public FileHistoryGraph getGraph() {
        return this.graph;
    }

    @Override
    public IFileHistoryEdge.Type getType() {
        return this.type;
    }

    @Override
    public IFileDiff getDiff() {
        return this.getTarget().getDiff();
    }

    @Override
    public ProxyableFileHistoryNode getAncestor() {
        return this.getTarget().getAncestor();
    }

    @Override
    public ProxyableFileHistoryNode getDescendant() {
        return this.getTarget().getDescendant();
    }

    @Override
    void setType(IFileHistoryEdge.Type type) {
        this.getTarget().setType(type);
    }

    private synchronized FileHistoryEdge getTarget() {
        if (this.target == null) {
            ProxyableFileHistoryNode ancestor = this.graph.getNodeFor(this.ancestorFile);
            assert (ancestor != null);
            ProxyableFileHistoryNode descendant = this.graph.getNodeFor(this.descendantFile);
            assert (descendant != null);
            this.target = new FileHistoryEdge(this.graph, ancestor, descendant, this.type);
        }
        return this.target;
    }
}

