/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.model.api.IDelta;
import de.setsoftware.reviewtool.model.api.IFileDiff;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.IFragmentList;
import de.setsoftware.reviewtool.model.api.IHunk;
import de.setsoftware.reviewtool.model.api.IPositionInText;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.api.IncompatibleFragmentException;
import de.setsoftware.reviewtool.model.changestructure.Delta;
import de.setsoftware.reviewtool.model.changestructure.Fragment;
import de.setsoftware.reviewtool.model.changestructure.FragmentList;
import de.setsoftware.reviewtool.model.changestructure.Hunk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public final class FileDiff
implements IFileDiff {
    private static final long serialVersionUID = -3942922342076568059L;
    private final List<IHunk> hunks;
    private final IRevisionedFile fromRevision;
    private final IRevisionedFile toRevision;

    public FileDiff(IRevisionedFile revision) {
        this.hunks = new ArrayList<IHunk>();
        this.fromRevision = revision;
        this.toRevision = revision;
    }

    public FileDiff(IRevisionedFile fromRevision, IRevisionedFile toRevision) {
        this.hunks = new ArrayList<IHunk>();
        this.fromRevision = fromRevision;
        this.toRevision = toRevision;
    }

    private FileDiff(IRevisionedFile fromRevision, IRevisionedFile toRevision, List<? extends IHunk> hunks) {
        this.hunks = new ArrayList<IHunk>(hunks);
        this.fromRevision = fromRevision;
        this.toRevision = toRevision;
    }

    public List<IHunk> getHunks() {
        return Collections.unmodifiableList(this.hunks);
    }

    @Override
    public IRevisionedFile getFrom() {
        return this.fromRevision;
    }

    @Override
    public IRevisionedFile getTo() {
        return this.toRevision;
    }

    @Override
    public IFileDiff setTo(IRevisionedFile newTo) {
        return new FileDiff(this.fromRevision, newTo, this.hunks);
    }

    @Override
    public IFragment traceFragment(IFragment source) {
        try {
            return this.createCombinedFragment(source).setFile(this.toRevision);
        }
        catch (IncompatibleFragmentException e) {
            throw new ReviewtoolException(e);
        }
    }

    public List<IHunk> getHunksWithTargetChangesInOneOf(Collection<? extends IFragment> fragments) {
        ArrayList<IHunk> result = new ArrayList<IHunk>();
        for (IHunk hunk : this.hunks) {
            if (!hunk.getTarget().containsChangeInOneOf(fragments)) continue;
            result.add(hunk);
        }
        return result;
    }

    @Override
    public IFileDiff merge(IHunk hunkToMerge) throws IncompatibleFragmentException {
        FileDiff result = new FileDiff(this.fromRevision, hunkToMerge.getTarget().getFile());
        ArrayList<IHunk> stashedHunks = new ArrayList<IHunk>();
        IDelta hunkDelta = hunkToMerge.getDelta();
        int hunkStartLine = hunkToMerge.getSource().getFrom().getLine();
        boolean hunkCreated = false;
        for (IHunk hunk : this.hunks) {
            if (hunk.getTarget().overlaps(hunkToMerge.getSource())) {
                stashedHunks.add(hunk);
                continue;
            }
            if (hunk.getTarget().getTo().compareTo(hunkToMerge.getSource().getFrom()) <= 0) {
                result.hunks.add(hunk.adjustTargetFile(result.toRevision));
                continue;
            }
            if (hunkCreated) {
                result.hunks.add(hunk.adjustTarget(hunkDelta.ignoreColumnOffset(hunk.getTarget().getFrom().getLine() != hunkStartLine)).adjustTargetFile(result.toRevision));
                continue;
            }
            result.hunks.add(this.createCombinedHunk(stashedHunks, hunkToMerge).adjustSourceFile(this.fromRevision).adjustTargetFile(result.toRevision));
            result.hunks.add(hunk.adjustTarget(hunkDelta.ignoreColumnOffset(hunk.getTarget().getFrom().getLine() != hunkStartLine)).adjustTargetFile(result.toRevision));
            hunkCreated = true;
        }
        if (!hunkCreated) {
            result.hunks.add(this.createCombinedHunk(stashedHunks, hunkToMerge).adjustSourceFile(this.fromRevision).adjustTargetFile(result.toRevision));
        }
        return result;
    }

    @Override
    public IFileDiff merge(Collection<? extends IHunk> hunksToMerge) throws IncompatibleFragmentException {
        IFileDiff result = this;
        IDelta delta = new Delta();
        int lastLine = 0;
        for (IHunk iHunk : hunksToMerge) {
            delta = delta.ignoreColumnOffset(iHunk.getSource().getFrom().getLine() != lastLine);
            result = result.merge(iHunk.adjustSource(delta));
            delta = delta.plus(iHunk.getDelta());
            lastLine = iHunk.getSource().getTo().getLine();
        }
        return result;
    }

    @Override
    public IFileDiff merge(IFileDiff diff) throws IncompatibleFragmentException {
        return this.merge(diff.getHunks()).setTo(diff.getTo());
    }

    private IHunk createCombinedHunk(Collection<? extends IHunk> hunks, IHunk hunkToMerge) throws IncompatibleFragmentException {
        FragmentList sources = new FragmentList();
        try {
            for (IHunk iHunk : hunks) {
                sources.addFragment(iHunk.getSource());
            }
        }
        catch (IncompatibleFragmentException incompatibleFragmentException) {
            throw new ReviewtoolException(incompatibleFragmentException);
        }
        FragmentList fragmentList = new FragmentList();
        try {
            for (IHunk iHunk : hunks) {
                fragmentList.addFragment(iHunk.getTarget());
            }
        }
        catch (IncompatibleFragmentException incompatibleFragmentException) {
            throw new ReviewtoolException(incompatibleFragmentException);
        }
        return new Hunk(this.combineSources(hunkToMerge, sources, fragmentList), this.combineTargets(hunkToMerge, fragmentList));
    }

    private IFragment createCombinedFragment(IFragment fragment) throws IncompatibleFragmentException {
        FragmentList result = new FragmentList();
        IFragment fragmentRest = fragment;
        IDelta delta = new Delta();
        int lastLine = 0;
        for (IHunk hunk : this.hunks) {
            IFragment source = hunk.getSource();
            if (source.overlaps(fragment)) {
                IFragment target = hunk.getTarget();
                result.addFragment(target);
                if (fragmentRest != null) {
                    IFragmentList pieces = fragmentRest.subtract(source);
                    fragmentRest = null;
                    for (IFragment iFragment : pieces.getFragments()) {
                        if (iFragment.getTo().compareTo(source.getFrom()) <= 0) {
                            delta = delta.ignoreColumnOffset(iFragment.getFrom().getLine() != lastLine);
                            result.addFragment(iFragment.adjust(delta));
                            continue;
                        }
                        fragmentRest = iFragment;
                    }
                }
            } else if (fragment.getTo().compareTo(source.getFrom()) <= 0) break;
            delta = delta.ignoreColumnOffset(hunk.getSource().getFrom().getLine() != lastLine);
            delta = delta.plus(hunk.getDelta());
            lastLine = hunk.getSource().getTo().getLine();
        }
        if (fragmentRest != null) {
            delta = delta.ignoreColumnOffset(fragmentRest.getFrom().getLine() != lastLine);
            result.addFragment(fragmentRest.adjust(delta));
        }
        result.coalesce();
        if (result.getFragments().size() != 1) {
            throw new IncompatibleFragmentException();
        }
        return result.getFragments().get(0);
    }

    private IFragment combineSources(IHunk hunkToMerge, IFragmentList sources, IFragmentList targets) throws IncompatibleFragmentException {
        FragmentList combinedSources = new FragmentList();
        combinedSources.addFragmentList(sources);
        for (IFragment iFragment : hunkToMerge.getSource().subtract(targets).getFragments()) {
            combinedSources.addFragment(iFragment.adjust(this.computeDeltaViaTargetFragmentUpTo(iFragment.getFrom()).negate()));
        }
        combinedSources.coalesce();
        if (combinedSources.getFragments().size() != 1) {
            throw new IncompatibleFragmentException();
        }
        return combinedSources.getFragments().get(0);
    }

    private IFragment combineTargets(IHunk hunkToMerge, IFragmentList targets) throws IncompatibleFragmentException {
        FragmentList adjustedTargets = new FragmentList();
        IDelta hunkDelta = hunkToMerge.getDelta();
        IFragment hunkTarget = hunkToMerge.getTarget();
        IPositionInText hunkTargetStart = hunkTarget.getFrom();
        LinkedHashSet<IFragment> hunkOrigins = new LinkedHashSet<IFragment>();
        hunkOrigins.add(hunkTarget);
        try {
            for (IFragment iFragment : targets.getFragments()) {
                if (iFragment.overlaps(hunkToMerge.getSource())) {
                    hunkOrigins.add(iFragment);
                    IFragmentList pieces = iFragment.subtract(hunkToMerge.getSource());
                    for (IFragment iFragment2 : pieces.getFragments()) {
                        if (iFragment2.getTo().compareTo(hunkTargetStart) <= 0) {
                            adjustedTargets.addFragment(iFragment2);
                            continue;
                        }
                        adjustedTargets.addFragment(iFragment2.adjust(hunkDelta));
                    }
                    continue;
                }
                if (iFragment.getTo().compareTo(hunkTargetStart) <= 0) {
                    adjustedTargets.addFragment(iFragment);
                    continue;
                }
                adjustedTargets.addFragment(iFragment.adjust(hunkDelta));
            }
        }
        catch (IncompatibleFragmentException incompatibleFragmentException) {
            throw new ReviewtoolException(incompatibleFragmentException);
        }
        Fragment fragment = new Fragment(hunkTarget.getFile(), hunkTarget.getFrom(), hunkTarget.getTo(), (Collection<? extends IFragment>)hunkOrigins);
        IFragmentList combinedTargets = adjustedTargets.overlayBy(fragment);
        combinedTargets.coalesce();
        if (combinedTargets.getFragments().size() != 1) {
            throw new IncompatibleFragmentException();
        }
        return combinedTargets.getFragments().get(0);
    }

    private IDelta computeDeltaViaTargetFragmentUpTo(IPositionInText pos) {
        IDelta delta = new Delta();
        int lastLine = 0;
        for (IHunk hunk : this.hunks) {
            if (hunk.getTarget().getTo().compareTo(pos) > 0) break;
            delta = delta.ignoreColumnOffset(hunk.getTarget().getFrom().getLine() != lastLine);
            delta = delta.plus(hunk.getDelta());
            lastLine = hunk.getTarget().getTo().getLine();
        }
        return delta.ignoreColumnOffset(pos.getLine() != lastLine);
    }
}

