/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.model.api.IDelta;

public final class Delta
implements IDelta {
    private static final long serialVersionUID = 3698918072368955600L;
    private final int lineOffset;
    private final int columnOffset;

    Delta() {
        this(0, 0);
    }

    Delta(int lineOffset, int columnOffset) {
        this.lineOffset = lineOffset;
        this.columnOffset = columnOffset;
    }

    public int hashCode() {
        return (100 * this.lineOffset + this.columnOffset) * 37;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Delta)) {
            return false;
        }
        Delta p = (Delta)o;
        return this.lineOffset == p.lineOffset && this.columnOffset == p.columnOffset;
    }

    public String toString() {
        return "(" + this.lineOffset + "," + this.columnOffset + ")";
    }

    @Override
    public int getLineOffset() {
        return this.lineOffset;
    }

    @Override
    public int getColumnOffset() {
        return this.columnOffset;
    }

    @Override
    public boolean isInline() {
        return this.lineOffset == 0;
    }

    @Override
    public IDelta plus(IDelta other) {
        return new Delta(this.lineOffset + other.getLineOffset(), this.columnOffset + other.getColumnOffset());
    }

    @Override
    public Delta minus(IDelta other) {
        return new Delta(this.lineOffset - other.getLineOffset(), this.columnOffset - other.getColumnOffset());
    }

    @Override
    public IDelta negate() {
        return new Delta(-this.lineOffset, -this.columnOffset);
    }

    @Override
    public IDelta ignoreColumnOffset() {
        return this.ignoreColumnOffset(true);
    }

    @Override
    public IDelta ignoreColumnOffset(boolean ignore) {
        return new Delta(this.lineOffset, ignore ? 0 : this.columnOffset);
    }
}

