/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.model.api.FileChangeType;
import de.setsoftware.reviewtool.model.api.IChange;
import de.setsoftware.reviewtool.model.api.IClassification;
import de.setsoftware.reviewtool.model.api.IWorkingCopy;
import java.util.Arrays;

public abstract class Change
implements IChange {
    private final IWorkingCopy wc;
    private final FileChangeType fileChangeType;
    private final IClassification[] classification;

    public Change(IWorkingCopy wc, FileChangeType fileChangeType, IClassification[] classification) {
        this.wc = wc;
        this.fileChangeType = fileChangeType;
        this.classification = classification;
    }

    protected IClassification[] concatClassification(IClassification cl) {
        IClassification[] ret = Arrays.copyOf(this.classification, this.classification.length + 1);
        ret[this.classification.length] = cl;
        return ret;
    }

    @Override
    public final IClassification[] getClassification() {
        return this.classification;
    }

    @Override
    public final IWorkingCopy getWorkingCopy() {
        return this.wc;
    }

    @Override
    public final FileChangeType getType() {
        return this.fileChangeType;
    }

    public int hashCode() {
        return this.wc.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Change)) {
            return false;
        }
        Change t = (Change)o;
        return this.wc.equals(t.wc) && this.fileChangeType.equals((Object)t.fileChangeType) && Arrays.equals(this.classification, t.classification);
    }
}

