/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.model.api.IFileDiff;
import de.setsoftware.reviewtool.model.api.IFileHistoryEdge;
import de.setsoftware.reviewtool.model.api.IFileHistoryNode;
import de.setsoftware.reviewtool.model.changestructure.FileDiff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractFileHistoryNode
implements IFileHistoryNode {
    private static final ThreadLocal<Boolean> inToString = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    @Override
    public final Set<? extends IFileDiff> buildHistories(IFileHistoryNode from) {
        if (from.equals(this)) {
            return Collections.singleton(new FileDiff(from.getFile(), from.getFile()));
        }
        if (!this.isRoot()) {
            LinkedHashSet<IFileDiff> result = new LinkedHashSet<IFileDiff>();
            for (IFileHistoryEdge iFileHistoryEdge : this.getAncestors()) {
                for (IFileDiff iFileDiff : iFileHistoryEdge.getAncestor().buildHistories(from)) {
                    try {
                        result.add(iFileDiff.merge(iFileHistoryEdge.getDiff()));
                    }
                    catch (Exception e) {
                        throw new ReviewtoolException(e);
                    }
                }
            }
            return result;
        }
        return Collections.emptySet();
    }

    public String toString() {
        if (inToString.get().booleanValue()) {
            return this.getFile().toString();
        }
        inToString.set(true);
        try {
            ArrayList<String> attributes = new ArrayList<String>();
            this.attributesToString(attributes);
            if (attributes.isEmpty()) {
                String string = this.getFile().toString();
                return string;
            }
            String string = String.valueOf(this.getFile().toString()) + ((Object)attributes).toString();
            return string;
        }
        finally {
            inToString.set(false);
        }
    }

    protected void attributesToString(List<String> attributes) {
        Set<? extends IFileHistoryEdge> descendants;
        attributes.add("state=" + (Object)((Object)this.getType()));
        if (!this.isRoot()) {
            LinkedHashSet<IFileHistoryNode> nodes = new LinkedHashSet<IFileHistoryNode>();
            for (IFileHistoryEdge iFileHistoryEdge : this.getAncestors()) {
                nodes.add(iFileHistoryEdge.getAncestor());
            }
            attributes.add("ancestors=" + nodes);
        }
        if (!(descendants = this.getDescendants()).isEmpty()) {
            LinkedHashSet<IFileHistoryNode> linkedHashSet = new LinkedHashSet<IFileHistoryNode>();
            for (IFileHistoryEdge iFileHistoryEdge : descendants) {
                linkedHashSet.add(iFileHistoryEdge.getDescendant());
            }
            attributes.add("descendants=" + linkedHashSet);
        }
    }
}

