/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model;

import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.model.IReviewDataCache;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class FileReviewDataCache
implements IReviewDataCache {
    private final File localStateDirectory;

    public FileReviewDataCache(File localStateDirectory) {
        this.localStateDirectory = localStateDirectory;
    }

    private File getFile(String key) {
        return new File(this.localStateDirectory, "localReviewData." + key);
    }

    @Override
    public void saveLocalReviewData(String key, String data) {
        try {
            Files.write(this.getFile(key).toPath(), data.getBytes("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ReviewtoolException(e);
        }
    }

    @Override
    public String getLocalReviewData(String key) {
        try {
            File file = this.getFile(key);
            if (file.exists()) {
                byte[] bytes = Files.readAllBytes(file.toPath());
                return new String(bytes, "UTF-8");
            }
            return null;
        }
        catch (IOException e) {
            throw new ReviewtoolException(e);
        }
    }

    @Override
    public void clearLocalReviewData(String key) {
        this.getFile(key).delete();
    }
}

