/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.base.tree;

import de.setsoftware.reviewtool.base.Pair;
import de.setsoftware.reviewtool.base.tree.TreeNode;
import de.setsoftware.reviewtool.base.tree.TreeNodeIterator;
import java.util.List;
import java.util.function.Predicate;

public final class FilteredTreeNodeIterator<K, V, N extends TreeNode<K, V, N>>
implements TreeNodeIterator<K, V, N> {
    private final TreeNodeIterator<K, V, N> baseIt;
    private final Predicate<N> predicate;
    private Pair<List<K>, N> nextNode;

    public FilteredTreeNodeIterator(TreeNodeIterator<K, V, N> baseIt, Predicate<N> predicate) {
        this.baseIt = baseIt;
        this.predicate = predicate;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.nextNode != null;
    }

    @Override
    public Pair<List<K>, N> next() {
        Pair<List<K>, N> result = this.nextNode;
        this.advance();
        return result;
    }

    private void advance() {
        while (this.baseIt.hasNext()) {
            this.nextNode = (Pair)this.baseIt.next();
            if (!this.predicate.test((TreeNode)this.nextNode.getSecond())) continue;
            return;
        }
        this.nextNode = null;
    }
}

