/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.base;

import de.setsoftware.reviewtool.base.IPartiallyComparable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public final class PartialOrderAlgorithms {
    public static <T extends IPartiallyComparable<T>, U extends T> U getSomeMinimum(Collection<U> elements) {
        IPartiallyComparable smallestSoFar = null;
        for (IPartiallyComparable e : elements) {
            if (smallestSoFar == null) {
                smallestSoFar = e;
                continue;
            }
            if (!e.le(smallestSoFar)) continue;
            smallestSoFar = e;
        }
        return (U)smallestSoFar;
    }

    public static <T extends IPartiallyComparable<T>, U extends T> U getSomeMaximum(Collection<U> elements) {
        IPartiallyComparable smallestSoFar = null;
        for (IPartiallyComparable e : elements) {
            if (smallestSoFar == null) {
                smallestSoFar = e;
                continue;
            }
            if (!smallestSoFar.le(e)) continue;
            smallestSoFar = e;
        }
        return (U)smallestSoFar;
    }

    public static <T extends IPartiallyComparable<T>, U extends T> List<U> getAllMinimalElements(Collection<U> elements) {
        ArrayList<IPartiallyComparable> result = new ArrayList<IPartiallyComparable>();
        ArrayDeque<U> input = new ArrayDeque<U>(elements);
        while (!input.isEmpty()) {
            IPartiallyComparable minimum = (IPartiallyComparable)input.removeFirst();
            result.add(minimum);
            Iterator it = input.iterator();
            while (it.hasNext()) {
                IPartiallyComparable element = (IPartiallyComparable)it.next();
                if (!minimum.le(element)) continue;
                it.remove();
            }
        }
        return result;
    }

    public static <T extends IPartiallyComparable<T>, U extends T> List<U> getAllMaximalElements(Collection<U> elements) {
        ArrayList<IPartiallyComparable> result = new ArrayList<IPartiallyComparable>();
        ArrayDeque<U> input = new ArrayDeque<U>(elements);
        while (!input.isEmpty()) {
            IPartiallyComparable maximum = (IPartiallyComparable)input.removeLast();
            result.add(maximum);
            Iterator it = input.iterator();
            while (it.hasNext()) {
                IPartiallyComparable element = (IPartiallyComparable)it.next();
                if (!element.le(maximum)) continue;
                it.remove();
            }
        }
        return result;
    }

    public static <T extends IPartiallyComparable<T>, U extends T> List<U> topoSort(Collection<U> toSort) {
        if (toSort.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<U> remainingElements = new LinkedHashSet<U>(toSort);
        ArrayList<U> ret = new ArrayList<U>();
        while (!remainingElements.isEmpty()) {
            U minimum = PartialOrderAlgorithms.getSomeMinimum(remainingElements);
            ret.add(minimum);
            remainingElements.remove(minimum);
        }
        return ret;
    }
}

