/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.remarks;

import de.setsoftware.reviewtool.model.remarks.GlobalPosition;
import de.setsoftware.reviewtool.model.remarks.IMarkerFactory;
import de.setsoftware.reviewtool.model.remarks.Position;
import de.setsoftware.reviewtool.model.remarks.RemarkType;
import de.setsoftware.reviewtool.model.remarks.ResolutionType;
import de.setsoftware.reviewtool.model.remarks.ReviewData;
import de.setsoftware.reviewtool.model.remarks.ReviewRemark;
import de.setsoftware.reviewtool.model.remarks.ReviewRemarkException;
import de.setsoftware.reviewtool.model.remarks.ReviewRound;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ReviewDataParser {
    private static final String TYPE_PREFIX = "* ";
    private static final String REMARK_PREFIX = "*# ";
    private static final String COMMENT_PREFIX = "*#* ";
    private static final Pattern REVIEW_HEADER_PATTERN = Pattern.compile("[^a-zA-Z0-9]*review[^a-zA-Z0-9]+(\\d+)[^a-zA-Z0-9]*", 2);
    private static final Pattern COMMENT_PATTERN = Pattern.compile("([^ ]+): (.+)", 32);
    private final IMarkerFactory markerFactory;
    private ParseState state = ParseState.BEFORE_REMARK;
    private final Map<Integer, String> reviewersForRounds;
    private ReviewRound currentRound;
    private final List<ReviewRound> rounds = new ArrayList<ReviewRound>();
    private RemarkType currentType = RemarkType.CAN_FIX;
    private final StringBuilder currentText = new StringBuilder();
    private ReviewRemark currentRemark;

    public ReviewDataParser(Map<Integer, String> reviewersForRounds, IMarkerFactory markerFactory) {
        this.reviewersForRounds = reviewersForRounds;
        this.markerFactory = markerFactory;
    }

    public void handleNextLine(String trimmedLine) throws ReviewRemarkException {
        Matcher roundStartMatcher = REVIEW_HEADER_PATTERN.matcher(trimmedLine);
        if (roundStartMatcher.matches()) {
            this.currentRound = this.getOrCreateRound(Integer.parseInt(roundStartMatcher.group(1)));
            this.state = ParseState.BEFORE_REMARK;
        } else if (trimmedLine.isEmpty()) {
            this.endLastItem();
            this.state = ParseState.BEFORE_REMARK;
            this.currentRemark = null;
            this.currentType = RemarkType.CAN_FIX;
        } else if (trimmedLine.startsWith(TYPE_PREFIX)) {
            this.endLastItem();
            RemarkType type = this.parseType(trimmedLine);
            if (type != null) {
                this.currentType = type;
                this.state = ParseState.BEFORE_REMARK;
            } else {
                this.parseRemarkOrCommentStart(trimmedLine);
                this.state = ParseState.IN_REMARK;
            }
        } else if (trimmedLine.startsWith(REMARK_PREFIX)) {
            this.endLastItem();
            this.parseRemarkOrCommentStart(trimmedLine);
            this.state = ParseState.IN_REMARK;
        } else if (trimmedLine.startsWith(COMMENT_PREFIX)) {
            this.endLastItem();
            this.parseRemarkOrCommentStart(trimmedLine);
            this.state = ParseState.IN_COMMENT;
        } else if (trimmedLine.startsWith("-") || trimmedLine.startsWith("#") || trimmedLine.startsWith("*")) {
            this.endLastItem();
            this.parseRemarkOrCommentStart(trimmedLine);
            this.state = ParseState.IN_REMARK;
        } else {
            if (this.state == ParseState.IN_REMARK || this.state == ParseState.IN_COMMENT) {
                this.currentText.append("\n");
            } else {
                this.state = ParseState.IN_REMARK;
            }
            this.currentText.append(trimmedLine);
        }
    }

    private ReviewRound getOrCreateRound(int number) {
        for (ReviewRound round : this.rounds) {
            if (round.getNumber() != number) continue;
            return round;
        }
        ReviewRound newRound = new ReviewRound(number);
        this.rounds.add(newRound);
        return newRound;
    }

    private RemarkType parseType(String trimmedLine) {
        return ReviewRound.parseType(trimmedLine.substring(2));
    }

    private void parseRemarkOrCommentStart(String trimmedLine) {
        String remaining = trimmedLine;
        while (remaining.startsWith("*") || remaining.startsWith("#") || remaining.startsWith("-") || remaining.startsWith(" ")) {
            remaining = remaining.substring(1);
        }
        this.currentText.append(remaining);
    }

    void endLastItem() throws ReviewRemarkException {
        switch (this.state) {
            case IN_REMARK: {
                ResolutionType resoRemark = this.handleResolutionMarkers();
                Position pos = this.parsePosition();
                this.currentRemark = ReviewRemark.create(this.markerFactory.createMarker(pos), this.getReviewerForCurrentRound(), pos, this.currentText.toString(), this.currentType);
                if (resoRemark != null) {
                    this.currentRemark.setResolution(resoRemark);
                }
                this.getCurrentRound().add(this.currentRemark);
                break;
            }
            case IN_COMMENT: {
                ResolutionType resoComment = this.handleResolutionMarkers();
                Matcher m = COMMENT_PATTERN.matcher(this.currentText);
                if (m.matches()) {
                    if (this.currentRemark == null) {
                        throw new ReviewRemarkException("dangling comment: " + this.currentText);
                    }
                    this.currentRemark.addComment(m.group(1), m.group(2));
                    if (resoComment == null) break;
                    this.currentRemark.setResolution(resoComment);
                    break;
                }
                throw new ReviewRemarkException("parse exception: " + this.currentText);
            }
            case BEFORE_REMARK: {
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown state " + (Object)((Object)this.state)));
            }
        }
        this.currentText.setLength(0);
    }

    private ReviewRound getCurrentRound() {
        return this.currentRound != null ? this.currentRound : this.getOrCreateRound(1);
    }

    private Position parsePosition() {
        String text = this.currentText.toString();
        if (text.startsWith("(")) {
            String position = text.substring(0, text.indexOf(41) + 1);
            this.currentText.setLength(0);
            this.currentText.append(text.substring(position.length()).trim());
            return Position.parse(position);
        }
        return new GlobalPosition();
    }

    private ResolutionType handleResolutionMarkers() {
        String text = this.currentText.toString();
        if (text.contains("(/)")) {
            this.currentText.setLength(0);
            this.currentText.append(text.replace("(/)", "").trim());
            return ResolutionType.FIXED;
        }
        if (text.contains("(x)")) {
            this.currentText.setLength(0);
            this.currentText.append(text.replace("(x)", "").trim());
            return ResolutionType.WONT_FIX;
        }
        if (text.contains("(?)")) {
            this.currentText.setLength(0);
            this.currentText.append(text.replace("(?)", "").trim());
            return ResolutionType.QUESTION;
        }
        return null;
    }

    public ReviewData getResult() throws ReviewRemarkException {
        if (this.rounds.isEmpty()) {
            return new ReviewData();
        }
        TreeMap<Integer, ReviewRound> roundMap = new TreeMap<Integer, ReviewRound>();
        for (ReviewRound round : this.rounds) {
            if (roundMap.containsKey(round.getNumber())) {
                throw new ReviewRemarkException("duplicate round: " + round.getNumber());
            }
            roundMap.put(round.getNumber(), round);
        }
        ArrayList<ReviewRound> sortedRounds = new ArrayList<ReviewRound>();
        int maxNumber = (Integer)roundMap.lastKey();
        int i = 1;
        while (i <= maxNumber) {
            if (roundMap.containsKey(i)) {
                sortedRounds.add((ReviewRound)roundMap.get(i));
            } else {
                sortedRounds.add(new ReviewRound(i));
            }
            ++i;
        }
        return new ReviewData(sortedRounds);
    }

    private String getReviewerForCurrentRound() {
        String r = this.reviewersForRounds.get(this.getCurrentRound().getNumber());
        return r != null ? r : "??";
    }

    private static enum ParseState {
        BEFORE_REMARK,
        IN_REMARK,
        IN_COMMENT;

    }
}

