/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.remarks;

import de.setsoftware.reviewtool.model.remarks.Position;

public class FileLinePosition
extends Position {
    private final String shortName;
    private final int line;

    public FileLinePosition(String shortName, int line) {
        this.shortName = shortName;
        this.line = line;
    }

    @Override
    public String serialize() {
        return "(" + this.shortName + ", " + this.line + ")";
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public String getShortFileName() {
        return this.shortName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileLinePosition)) {
            return false;
        }
        FileLinePosition p = (FileLinePosition)o;
        return p.shortName.equals(this.shortName) && p.line == this.line;
    }

    public int hashCode() {
        return this.shortName.hashCode() ^ this.line;
    }

    public String toString() {
        return this.serialize();
    }
}

