/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.git;

import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.diffalgorithms.DiffAlgorithmFactory;
import de.setsoftware.reviewtool.model.api.IMutableFileHistoryGraph;
import de.setsoftware.reviewtool.model.api.IRepoRevision;
import de.setsoftware.reviewtool.model.changestructure.AbstractRepository;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryGraph;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

final class GitRepository
extends AbstractRepository {
    private static final long serialVersionUID = -6614056402124460918L;
    private final File cacheDir;
    private final File workingCopyRoot;
    private transient AtomicBoolean saveCacheWaiting;
    private transient Repository gitRepository;
    private final Set<String> analyzedCommits;
    private IMutableFileHistoryGraph fileHistoryGraph;

    private GitRepository(File workingCopyRoot, File cacheDir) {
        this.workingCopyRoot = workingCopyRoot;
        this.cacheDir = cacheDir;
        this.analyzedCommits = new HashSet<String>();
        this.fileHistoryGraph = new FileHistoryGraph(DiffAlgorithmFactory.createDefault());
    }

    public static GitRepository create(File workingCopyRoot, File cacheDir) {
        GitRepository fromCache = GitRepository.loadFromCache(workingCopyRoot, cacheDir);
        if (fromCache != null && fromCache.workingCopyRoot.equals(workingCopyRoot)) {
            return fromCache;
        }
        return new GitRepository(workingCopyRoot, cacheDir);
    }

    Repository getRepository() {
        if (this.gitRepository == null) {
            try {
                this.gitRepository = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(this.workingCopyRoot)).build();
            }
            catch (IOException e) {
                throw new ReviewtoolException((Exception)e);
            }
        }
        return this.gitRepository;
    }

    private static GitRepository loadFromCache(File wcRoot, File cacheDir) {
        File cacheFile = GitRepository.getCacheFilePath(wcRoot, cacheDir);
        if (cacheFile.exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream in = new FileInputStream(cacheFile);){
                    ObjectInputStream os = new ObjectInputStream(new BufferedInputStream(in));
                    return (GitRepository)((Object)os.readObject());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Logger.warn((String)"could not load git repo cache file", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveCacheInBackground() {
        if (this.saveCacheWaiting == null) {
            GitRepository gitRepository = this;
            synchronized (gitRepository) {
                if (this.saveCacheWaiting == null) {
                    this.saveCacheWaiting = new AtomicBoolean();
                }
            }
        }
        if (!this.saveCacheWaiting.compareAndSet(false, true)) {
            return;
        }
        new Thread(this::saveCache, "saveCacheThread " + (Object)((Object)this)).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveCache() {
        IMutableFileHistoryGraph iMutableFileHistoryGraph = this.fileHistoryGraph;
        synchronized (iMutableFileHistoryGraph) {
            this.saveCacheWaiting.set(false);
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileOutputStream in = new FileOutputStream(GitRepository.getCacheFilePath(this.workingCopyRoot, this.cacheDir));){
                    ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(in));
                    os.writeObject((Object)this);
                    os.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Logger.warn((String)"could not save git repo cache file", (Throwable)e);
            }
        }
    }

    public String getId() {
        return this.workingCopyRoot.getAbsolutePath();
    }

    /*
     * Exception decompiling
     */
    public byte[] getFileContents(String path, IRepoRevision<?> revision) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IMutableFileHistoryGraph getFileHistoryGraph() {
        return this.fileHistoryGraph;
    }

    private static File getCacheFilePath(File wcRoot, File cacheDir) {
        return new File(cacheDir, "git-" + GitRepository.encodeString(wcRoot.toString()) + ".cache");
    }

    private static String encodeString(String s) {
        return Base64.getUrlEncoder().encodeToString(s.getBytes());
    }

    synchronized boolean wasAlreadyAnalyzed(String revisionString) {
        return this.analyzedCommits.contains(revisionString);
    }

    synchronized void markAsAnalyzed(String revisionString) {
        this.analyzedCommits.add(revisionString);
    }

    public synchronized void clearCache() {
        File filePath = GitRepository.getCacheFilePath(this.workingCopyRoot, this.cacheDir);
        filePath.delete();
        if (!this.analyzedCommits.isEmpty()) {
            this.analyzedCommits.clear();
            this.fileHistoryGraph = new FileHistoryGraph(DiffAlgorithmFactory.createDefault());
        }
    }
}

