/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.core.ui.intellij.views.toolWindowPanels;

import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.core.ui.intellij.plugin.ReviewPlugin;
import de.setsoftware.reviewtool.core.ui.intellij.views.dialogs.RemarkMarkers;
import de.setsoftware.reviewtool.model.IReviewDataSaveListener;
import de.setsoftware.reviewtool.model.ITicketData;
import de.setsoftware.reviewtool.model.ReviewModeListener;
import de.setsoftware.reviewtool.model.ReviewStateManager;
import de.setsoftware.reviewtool.model.changestructure.ToursInReview;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001a2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001aB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/views/toolWindowPanels/CurrentlyReviewingToolWindowPanel;", "Ljavax/swing/JPanel;", "Lde/setsoftware/reviewtool/model/ReviewModeListener;", "Lde/setsoftware/reviewtool/model/IReviewDataSaveListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "currentReviewInfoLabel", "Lcom/intellij/ui/components/JBLabel;", "reviewRemarks", "Lcom/intellij/ui/components/JBTextArea;", "reviewStateManager", "Lde/setsoftware/reviewtool/model/ReviewStateManager;", "lastText", "", "notifyReview", "", "toursInReview", "Lde/setsoftware/reviewtool/model/changestructure/ToursInReview;", "notifyFixing", "notifyIdle", "onSave", "s", "handleReviewDataTextChanged", "newReviewData", "Companion", "IntelliJ-CoRT"})
@SourceDebugExtension(value={"SMAP\nCurrentlyReviewingToolWindowPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurrentlyReviewingToolWindowPanel.kt\nde/setsoftware/reviewtool/core/ui/intellij/views/toolWindowPanels/CurrentlyReviewingToolWindowPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class CurrentlyReviewingToolWindowPanel
extends JPanel
implements ReviewModeListener,
IReviewDataSaveListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JBLabel currentReviewInfoLabel;
    @NotNull
    private final JBTextArea reviewRemarks;
    @Nullable
    private ReviewStateManager reviewStateManager;
    @Nullable
    private String lastText;
    @NotNull
    private static final com.intellij.openapi.diagnostic.Logger LOG;

    public CurrentlyReviewingToolWindowPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ReviewPlugin.Companion.getInstance(this.project).registerModeListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        this.setLayout(new BorderLayout());
        this.currentReviewInfoLabel = new JBLabel();
        buttonPanel.add((Component)this.currentReviewInfoLabel);
        JButton endReviewButton = new JButton("Review beenden");
        endReviewButton.addActionListener(arg_0 -> CurrentlyReviewingToolWindowPanel._init_$lambda$0(this, arg_0));
        buttonPanel.add(endReviewButton);
        JButton copyButton = new JButton("Ticketnummer kopieren");
        copyButton.addActionListener(arg_0 -> CurrentlyReviewingToolWindowPanel._init_$lambda$2(this, arg_0));
        buttonPanel.add(copyButton);
        this.add((Component)buttonPanel, "North");
        this.reviewRemarks = new JBTextArea();
        this.reviewRemarks.setFont((Font)JBFont.regular());
        this.reviewRemarks.setBorder((Border)new JBEmptyBorder(3, 5, 3, 5));
        this.reviewRemarks.setLineWrap(true);
        this.reviewRemarks.setWrapStyleWord(true);
        this.add((Component)new JBScrollPane((Component)this.reviewRemarks), "Center");
        this.reviewRemarks.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String curText = reviewRemarks.getText();
                if (!Intrinsics.areEqual((Object)curText, (Object)lastText)) {
                    Intrinsics.checkNotNull((Object)curText);
                    this.handleReviewDataTextChanged(curText);
                }
            }
        });
    }

    public void notifyReview(@NotNull ReviewStateManager reviewStateManager, @NotNull ToursInReview toursInReview) {
        Intrinsics.checkNotNullParameter((Object)reviewStateManager, (String)"reviewStateManager");
        Intrinsics.checkNotNullParameter((Object)toursInReview, (String)"toursInReview");
        this.reviewStateManager = reviewStateManager;
        ITicketData ticketData = reviewStateManager.getCurrentTicketData();
        String string = "Aktuelles Review: %s";
        Object[] objectArray = new Object[]{ticketData.getId()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        this.currentReviewInfoLabel.setText(string2);
        String string3 = reviewStateManager.getCurrentReviewData();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCurrentReviewData(...)");
        this.onSave(string3);
        reviewStateManager.addSaveListener((IReviewDataSaveListener)this);
    }

    public void notifyFixing(@NotNull ReviewStateManager reviewStateManager) {
        Intrinsics.checkNotNullParameter((Object)reviewStateManager, (String)"reviewStateManager");
        this.reviewStateManager = reviewStateManager;
    }

    public void notifyIdle() {
        this.reviewStateManager = null;
    }

    public void onSave(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.lastText = s;
        this.reviewRemarks.setText(s);
    }

    private final void handleReviewDataTextChanged(String newReviewData) {
        ReviewStateManager reviewStateManager = this.reviewStateManager;
        if (reviewStateManager == null) {
            CurrentlyReviewingToolWindowPanel $this$handleReviewDataTextChanged_u24lambda_u243 = this;
            boolean bl = false;
            LOG.error("reviewStateManger is unexpectedly not defined.");
            return;
        }
        ReviewStateManager currentReviewStateManager = reviewStateManager;
        Logger.debug((String)"change in review remark text");
        currentReviewStateManager.saveCurrentReviewData(newReviewData);
        RemarkMarkers.INSTANCE.clearMarkers(this.project);
        RemarkMarkers.INSTANCE.loadRemarks(currentReviewStateManager, this.project);
        this.lastText = newReviewData;
    }

    private static final void _init_$lambda$0(CurrentlyReviewingToolWindowPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ReviewPlugin.Companion.getInstance(this$0.project).endReviewOrFixing();
    }

    private static final void _init_$lambda$2(CurrentlyReviewingToolWindowPanel this$0, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Object object = this$0.reviewStateManager;
            if (object == null || (object = object.getCurrentTicketData()) == null || (object = object.getId()) == null) break block0;
            Object ticketId = object;
            boolean bl = false;
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection((String)ticketId));
        }
    }

    static {
        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(CurrentlyReviewingToolWindowPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/views/toolWindowPanels/CurrentlyReviewingToolWindowPanel$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "IntelliJ-CoRT"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

