/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.core.ui.intellij.views.toolWindowPanels;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.core.ui.intellij.model.IntelliJMarker;
import de.setsoftware.reviewtool.core.ui.intellij.model.IntelliJMarkers;
import de.setsoftware.reviewtool.core.ui.intellij.plugin.ReviewPlugin;
import de.setsoftware.reviewtool.core.ui.intellij.views.dialogs.CorrectSyntaxDialog;
import de.setsoftware.reviewtool.core.ui.intellij.views.toolWindowPanels.fixing.CategoryForTree;
import de.setsoftware.reviewtool.core.ui.intellij.views.toolWindowPanels.fixing.CategoryItem;
import de.setsoftware.reviewtool.core.ui.intellij.views.toolWindowPanels.fixing.CortMutableTreeNode;
import de.setsoftware.reviewtool.core.ui.intellij.views.toolWindowPanels.fixing.CortTreeCellRenderer;
import de.setsoftware.reviewtool.core.ui.intellij.views.toolWindowPanels.fixing.MarkRemarkFixedAction;
import de.setsoftware.reviewtool.core.ui.intellij.views.toolWindowPanels.fixing.MarkRemarkFixedNoCommentAction;
import de.setsoftware.reviewtool.core.ui.intellij.views.toolWindowPanels.fixing.MarkRemarkUnclearAction;
import de.setsoftware.reviewtool.core.ui.intellij.views.toolWindowPanels.fixing.MarkRemarkWontFixAction;
import de.setsoftware.reviewtool.model.IReviewDataSaveListener;
import de.setsoftware.reviewtool.model.ReviewModeListener;
import de.setsoftware.reviewtool.model.ReviewStateManager;
import de.setsoftware.reviewtool.model.changestructure.ToursInReview;
import de.setsoftware.reviewtool.model.remarks.DummyMarker;
import de.setsoftware.reviewtool.model.remarks.IMarkerFactory;
import de.setsoftware.reviewtool.model.remarks.ReviewData;
import de.setsoftware.reviewtool.model.remarks.ReviewRemark;
import de.setsoftware.reviewtool.model.remarks.ReviewRemarkComment;
import de.setsoftware.reviewtool.model.remarks.ReviewRemarkException;
import de.setsoftware.reviewtool.model.remarks.ReviewRound;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u001cH\u0002J\u001c\u0010!\u001a\u00020\u00132\b\u0010\"\u001a\u0004\u0018\u00010\t2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020\u0013H\u0016J\u0012\u0010&\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u00010(H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/views/toolWindowPanels/CurrentlyFixingToolWindowPanel;", "Ljavax/swing/JPanel;", "Lde/setsoftware/reviewtool/model/ReviewModeListener;", "Lde/setsoftware/reviewtool/model/IReviewDataSaveListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "reviewStateManager", "Lde/setsoftware/reviewtool/model/ReviewStateManager;", "currentReviewInfoLabel", "Lcom/intellij/ui/components/JBLabel;", "initTreeNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "jumpToRemarkIfPossible", "", "reviewRemark", "Lde/setsoftware/reviewtool/model/remarks/ReviewRemark;", "setupContextMenu", "Lcom/intellij/openapi/ui/JBPopupMenu;", "notifyFixing", "mgr", "setupLayout", "data", "Lde/setsoftware/reviewtool/model/remarks/ReviewData;", "getTopLevelCategories", "", "Lde/setsoftware/reviewtool/core/ui/intellij/views/toolWindowPanels/fixing/CategoryItem;", "remarks", "notifyReview", "p0", "p1", "Lde/setsoftware/reviewtool/model/changestructure/ToursInReview;", "notifyIdle", "onSave", "newData", "", "IntelliJ-CoRT"})
@SourceDebugExtension(value={"SMAP\nCurrentlyFixingToolWindowPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurrentlyFixingToolWindowPanel.kt\nde/setsoftware/reviewtool/core/ui/intellij/views/toolWindowPanels/CurrentlyFixingToolWindowPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1855#2:223\n1855#2:224\n1855#2,2:225\n1856#2:227\n1856#2:228\n1864#2,2:229\n1855#2,2:231\n1866#2:233\n1549#2:234\n1620#2,3:235\n*S KotlinDebug\n*F\n+ 1 CurrentlyFixingToolWindowPanel.kt\nde/setsoftware/reviewtool/core/ui/intellij/views/toolWindowPanels/CurrentlyFixingToolWindowPanel\n*L\n163#1:223\n166#1:224\n169#1:225,2\n166#1:227\n163#1:228\n181#1:229,2\n183#1:231,2\n181#1:233\n193#1:234\n193#1:235,3\n*E\n"})
public final class CurrentlyFixingToolWindowPanel
extends JPanel
implements ReviewModeListener,
IReviewDataSaveListener {
    @Nullable
    private ReviewStateManager reviewStateManager;
    @NotNull
    private final JBLabel currentReviewInfoLabel;
    @NotNull
    private final DefaultMutableTreeNode initTreeNode;
    @NotNull
    private final DefaultTreeModel treeModel;
    @NotNull
    private final Tree tree;

    public CurrentlyFixingToolWindowPanel(final @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.currentReviewInfoLabel = new JBLabel();
        this.initTreeNode = new DefaultMutableTreeNode();
        this.treeModel = new DefaultTreeModel(this.initTreeNode);
        this.tree = new Tree((TreeModel)this.treeModel);
        ReviewPlugin.Companion.getInstance(project).registerModeListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        this.setLayout(new BorderLayout());
        buttonPanel.add((Component)this.currentReviewInfoLabel);
        JButton endReviewButton = new JButton("Fixing beenden");
        endReviewButton.addActionListener(arg_0 -> CurrentlyFixingToolWindowPanel._init_$lambda$0(project, arg_0));
        buttonPanel.add(endReviewButton);
        JButton copyButton = new JButton("Ticketnummer kopieren");
        copyButton.addActionListener(arg_0 -> CurrentlyFixingToolWindowPanel._init_$lambda$2(this, arg_0));
        buttonPanel.add(copyButton);
        this.add((Component)buttonPanel, "North");
        this.tree.setRootVisible(false);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.isPopupTrigger()) {
                    ReviewRemark reviewRemark = this.getReviewRemarkIfExists(e);
                    if (reviewRemark == null) {
                        return;
                    }
                    ReviewRemark reviewRemark2 = reviewRemark;
                    JBPopupMenu.showByEvent((MouseEvent)e, (JPopupMenu)((JPopupMenu)this.setupContextMenu(reviewRemark2, project)));
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getClickCount() == 2) {
                    ReviewRemark reviewRemark = this.getReviewRemarkIfExists(e);
                    if (reviewRemark == null) {
                        return;
                    }
                    ReviewRemark reviewRemark2 = reviewRemark;
                    this.jumpToRemarkIfPossible(project, reviewRemark2);
                }
            }

            private final ReviewRemark getReviewRemarkIfExists(MouseEvent e) {
                TreePath treePath = tree.getPathForLocation(e.getX(), e.getY());
                if (treePath == null) {
                    return null;
                }
                TreePath path = treePath;
                Object object = path.getLastPathComponent();
                CortMutableTreeNode cortMutableTreeNode = object instanceof CortMutableTreeNode ? (CortMutableTreeNode)object : null;
                Object object2 = cortMutableTreeNode != null ? cortMutableTreeNode.getUserObject() : null;
                return object2 instanceof ReviewRemark ? (ReviewRemark)object2 : null;
            }
        });
        this.tree.setCellRenderer((TreeCellRenderer)((Object)new CortTreeCellRenderer()));
        new TreeSpeedSearch((JTree)this.tree);
        this.add((Component)new JBScrollPane((Component)this.tree), "Center");
    }

    private final void jumpToRemarkIfPossible(Project project, ReviewRemark reviewRemark) {
        IntelliJMarker intelliJMarker = IntelliJMarkers.Companion.getInstance(project).findMarkerFor(reviewRemark);
        if (intelliJMarker == null) {
            return;
        }
        IntelliJMarker intelliJMarker2 = intelliJMarker;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        Collection collection = FilenameIndex.getVirtualFilesByName((String)intelliJMarker2.getPosition().getShortFileName(), (GlobalSearchScope)GlobalSearchScope.everythingScope((Project)project));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull((Iterable)collection);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        fileEditorManager.openTextEditor(new OpenFileDescriptor(project, file, intelliJMarker2.getPosition().getLine() - 1, -1), true);
    }

    private final JBPopupMenu setupContextMenu(ReviewRemark reviewRemark, Project project) {
        JBMenuItem jBMenuItem;
        JBPopupMenu popupMenu = new JBPopupMenu();
        JBMenuItem menuItem = jBMenuItem = new JBMenuItem("Mark remark as fixed");
        boolean bl = false;
        menuItem.addActionListener((ActionListener)new MarkRemarkFixedNoCommentAction(reviewRemark, project));
        popupMenu.add((JMenuItem)menuItem);
        menuItem = jBMenuItem = new JBMenuItem("Mark remark as fixed and add a comment ...");
        boolean bl2 = false;
        menuItem.addActionListener((ActionListener)new MarkRemarkFixedAction(reviewRemark, project));
        popupMenu.add((JMenuItem)menuItem);
        menuItem = jBMenuItem = new JBMenuItem("Mark remark as rejected ...");
        boolean bl3 = false;
        menuItem.addActionListener((ActionListener)new MarkRemarkWontFixAction(reviewRemark, project));
        popupMenu.add((JMenuItem)menuItem);
        menuItem = jBMenuItem = new JBMenuItem("Mark remark as unclear ...");
        boolean bl4 = false;
        menuItem.addActionListener((ActionListener)new MarkRemarkUnclearAction(reviewRemark, project));
        popupMenu.add((JMenuItem)menuItem);
        return popupMenu;
    }

    public void notifyFixing(@NotNull ReviewStateManager mgr) {
        Intrinsics.checkNotNullParameter((Object)mgr, (String)"mgr");
        this.reviewStateManager = mgr;
        mgr.addSaveListener((IReviewDataSaveListener)this);
        IMarkerFactory iMarkerFactory = DummyMarker.FACTORY;
        Intrinsics.checkNotNullExpressionValue((Object)iMarkerFactory, (String)"FACTORY");
        ReviewData reviewData = CorrectSyntaxDialog.Companion.getCurrentReviewDataParsed(mgr, iMarkerFactory);
        if (reviewData == null) {
            String string = "implement error-handling";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        ReviewData data = reviewData;
        this.currentReviewInfoLabel.setText("Aktuelles Fixing: " + mgr.getCurrentTicketData().getId());
        this.setupLayout(data);
        TreeUtil.expandAll((JTree)((JTree)this.tree));
    }

    private final void setupLayout(ReviewData data) {
        this.initTreeNode.removeAllChildren();
        List<CategoryItem> categories = this.getTopLevelCategories(data);
        Iterable $this$forEach$iv = categories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CategoryItem category = (CategoryItem)element$iv;
            boolean bl = false;
            CortMutableTreeNode categoryNode = new CortMutableTreeNode(category);
            this.initTreeNode.add(categoryNode);
            Iterable $this$forEach$iv2 = category.getRelevantRemarks(data);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ReviewRemark reviewRemark = (ReviewRemark)element$iv2;
                boolean bl2 = false;
                CortMutableTreeNode remarkNode = new CortMutableTreeNode(reviewRemark);
                categoryNode.add(remarkNode);
                List list = reviewRemark.getFollowUpComments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFollowUpComments(...)");
                Iterable $this$forEach$iv3 = list;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    ReviewRemarkComment it = (ReviewRemarkComment)element$iv3;
                    boolean bl3 = false;
                    remarkNode.add(new CortMutableTreeNode(it));
                }
            }
        }
        this.treeModel.reload();
    }

    /*
     * WARNING - void declaration
     */
    private final List<CategoryItem> getTopLevelCategories(ReviewData remarks) {
        void $this$mapTo$iv$iv;
        EnumSet<CategoryForTree> activeCategories = EnumSet.noneOf(CategoryForTree.class);
        List list = remarks.getReviewRounds();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getReviewRounds(...)");
        List reviewRounds = list;
        Iterable $this$forEachIndexed$iv = reviewRounds;
        boolean $i$f$forEachIndexed = false;
        int index$iv22 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void reviewRound;
            int n;
            if ((n = index$iv22++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ReviewRound reviewRound2 = (ReviewRound)item$iv;
            int index = n;
            boolean bl = false;
            boolean lastRound = index == reviewRounds.size() - 1;
            List list2 = reviewRound.getRemarks();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRemarks(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReviewRemark remark = (ReviewRemark)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)remark);
                activeCategories.add(CategoryItem.Companion.classify(remark, lastRound));
            }
        }
        Intrinsics.checkNotNull(activeCategories);
        Iterable $this$map$iv = activeCategories;
        boolean $i$f$map = false;
        Iterable index$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CategoryForTree index = (CategoryForTree)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new CategoryItem((CategoryForTree)it));
        }
        return (List)destination$iv$iv;
    }

    public void notifyReview(@Nullable ReviewStateManager p0, @Nullable ToursInReview p1) {
    }

    public void notifyIdle() {
        this.initTreeNode.removeAllChildren();
    }

    public void onSave(@Nullable String newData) {
        try {
            Object object = this.reviewStateManager;
            if (object == null || (object = object.getReviewersForRounds()) == null) {
                object = MapsKt.emptyMap();
            }
            ReviewData parsed = ReviewData.parse((Map)object, (IMarkerFactory)DummyMarker.FACTORY, (String)newData);
            Intrinsics.checkNotNull((Object)parsed);
            this.setupLayout(parsed);
            TreeUtil.expandAll((JTree)((JTree)this.tree));
        }
        catch (ReviewRemarkException e) {
            Logger.warn((String)"changed remarks could not be parsed", (Throwable)e);
        }
    }

    private static final void _init_$lambda$0(Project $project, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        ReviewPlugin.Companion.getInstance($project).endReviewOrFixing();
    }

    private static final void _init_$lambda$2(CurrentlyFixingToolWindowPanel this$0, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Object object = this$0.reviewStateManager;
            if (object == null || (object = object.getCurrentTicketData()) == null || (object = object.getId()) == null) break block0;
            Object ticketId = object;
            boolean bl = false;
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection((String)ticketId));
        }
    }
}

