/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.core.ui.intellij.model;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import de.setsoftware.reviewtool.core.ui.intellij.model.IntelliJMarker;
import de.setsoftware.reviewtool.core.ui.intellij.plugin.CortLineGutterIconRenderer;
import de.setsoftware.reviewtool.model.remarks.FileLinePosition;
import de.setsoftware.reviewtool.model.remarks.IReviewMarker;
import de.setsoftware.reviewtool.model.remarks.Position;
import de.setsoftware.reviewtool.model.remarks.ReviewRemark;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0011\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/model/IntelliJMarkers;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "markers", "", "Lde/setsoftware/reviewtool/model/remarks/Position;", "Lde/setsoftware/reviewtool/core/ui/intellij/model/IntelliJMarker;", "renderers", "Lde/setsoftware/reviewtool/core/ui/intellij/plugin/CortLineGutterIconRenderer;", "addMarker", "position", "deleteMarker", "", "toBeRemoved", "clearAllReviewMarkers", "refreshRenderers", "document", "Lcom/intellij/openapi/editor/Document;", "findMarkerFor", "toFind", "Lde/setsoftware/reviewtool/model/remarks/ReviewRemark;", "Companion", "IntelliJ-CoRT"})
@SourceDebugExtension(value={"SMAP\nIntelliJMarkers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJMarkers.kt\nde/setsoftware/reviewtool/core/ui/intellij/model/IntelliJMarkers\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,77:1\n515#2:78\n500#2,6:79\n215#3,2:85\n*S KotlinDebug\n*F\n+ 1 IntelliJMarkers.kt\nde/setsoftware/reviewtool/core/ui/intellij/model/IntelliJMarkers\n*L\n46#1:78\n46#1:79,6\n52#1:85,2\n*E\n"})
public final class IntelliJMarkers {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<Position, IntelliJMarker> markers;
    @NotNull
    private final Map<IntelliJMarker, CortLineGutterIconRenderer> renderers;

    private IntelliJMarkers(Project project) {
        this.project = project;
        this.markers = new HashMap();
        this.renderers = new HashMap();
    }

    @NotNull
    public final IntelliJMarker addMarker(@NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        IntelliJMarker ret = new IntelliJMarker(position, this.project);
        this.markers.put(position, ret);
        DaemonCodeAnalyzer.getInstance((Project)this.project).restart();
        return ret;
    }

    public final void deleteMarker(@NotNull IntelliJMarker toBeRemoved) {
        Intrinsics.checkNotNullParameter((Object)toBeRemoved, (String)"toBeRemoved");
        this.markers.remove(toBeRemoved.getPosition());
        CortLineGutterIconRenderer cortLineGutterIconRenderer = this.renderers.remove(toBeRemoved);
        if (cortLineGutterIconRenderer != null) {
            cortLineGutterIconRenderer.releaseHighlighter();
        }
        DaemonCodeAnalyzer.getInstance((Project)this.project).restart();
    }

    public final void clearAllReviewMarkers() {
        this.markers.clear();
        this.renderers.values().forEach(IntelliJMarkers::clearAllReviewMarkers$lambda$0);
        this.renderers.clear();
        DaemonCodeAnalyzer.getInstance((Project)this.project).restart();
    }

    /*
     * WARNING - void declaration
     */
    public final void refreshRenderers(@NotNull Document document) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String fileName = string;
        Map<Position, IntelliJMarker> map = this.markers;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            Position position = (Position)entry.getKey();
            IntelliJMarker marker = (IntelliJMarker)entry.getValue();
            if (!(position.getShortFileName() != null && StringsKt.endsWith$default((String)fileName, (String)("/" + position.getShortFileName()), (boolean)false, (int)2, null) && marker.getPosition() instanceof FileLinePosition && !this.renderers.containsKey(marker))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            IntelliJMarker marker = (IntelliJMarker)entry.getValue();
            CortLineGutterIconRenderer iconRenderer = new CortLineGutterIconRenderer(marker, document, this.project);
            iconRenderer.createHighlighter();
            this.renderers.put(marker, iconRenderer);
        }
    }

    @Nullable
    public final IntelliJMarker findMarkerFor(@NotNull ReviewRemark toFind) {
        IntelliJMarker intelliJMarker;
        Object v0;
        ReviewRemark storedMarker;
        IntelliJMarker it;
        Iterable iterable;
        block3: {
            Intrinsics.checkNotNullParameter((Object)toFind, (String)"toFind");
            iterable = this.markers.values();
            for (Object t : iterable) {
                it = (IntelliJMarker)t;
                boolean bl = false;
                storedMarker = ReviewRemark.getFor((IReviewMarker)it);
                if (!toFind.hasSameTextAndPositionAs(storedMarker)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((intelliJMarker = (IntelliJMarker)v0) == null) {
            Object v2;
            block4: {
                iterable = this.markers.values();
                for (Object t : iterable) {
                    it = (IntelliJMarker)t;
                    boolean bl = false;
                    storedMarker = ReviewRemark.getFor((IReviewMarker)it);
                    if (!Intrinsics.areEqual((Object)toFind.getText(), (Object)storedMarker.getText())) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            intelliJMarker = v2;
        }
        return intelliJMarker;
    }

    private static final void clearAllReviewMarkers$lambda$0(CortLineGutterIconRenderer obj) {
        Intrinsics.checkNotNullParameter((Object)((Object)obj), (String)"obj");
        obj.releaseHighlighter();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/model/IntelliJMarkers$Companion;", "", "<init>", "()V", "getInstance", "Lde/setsoftware/reviewtool/core/ui/intellij/model/IntelliJMarkers;", "project", "Lcom/intellij/openapi/project/Project;", "IntelliJ-CoRT"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntelliJMarkers getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(IntelliJMarkers.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (IntelliJMarkers)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

