/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.svn;

import de.setsoftware.reviewtool.base.Pair;
import de.setsoftware.reviewtool.changesources.svn.CachedLogEntryPath;
import de.setsoftware.reviewtool.changesources.svn.CachedLogLookupHandler;
import de.setsoftware.reviewtool.changesources.svn.SvnRepo;
import de.setsoftware.reviewtool.changesources.svn.SvnRepoRevision;
import de.setsoftware.reviewtool.changesources.svn.SvnRepositoryManager;
import de.setsoftware.reviewtool.changesources.svn.SvnWorkingCopy;
import de.setsoftware.reviewtool.changesources.svn.SvnWorkingCopyRevision;
import de.setsoftware.reviewtool.diffalgorithms.DiffAlgorithmFactory;
import de.setsoftware.reviewtool.model.api.BackgroundJobExecutor;
import de.setsoftware.reviewtool.model.api.IChangeSourceUi;
import de.setsoftware.reviewtool.model.api.IMutableFileHistoryGraph;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryGraph;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;

final class SvnWorkingCopyManager {
    private static final SvnWorkingCopyManager INSTANCE = new SvnWorkingCopyManager();
    private final Map<String, SvnWorkingCopy> wcPerRootDirectory = new LinkedHashMap<String, SvnWorkingCopy>();
    private SVNClientManager mgr;

    private SvnWorkingCopyManager() {
    }

    static SvnWorkingCopyManager getInstance() {
        return INSTANCE;
    }

    void init(SVNClientManager mgr) {
        this.mgr = mgr;
    }

    synchronized Collection<SvnWorkingCopy> getWorkingCopies() {
        return Collections.unmodifiableCollection(new ArrayList<SvnWorkingCopy>(this.wcPerRootDirectory.values()));
    }

    synchronized SvnWorkingCopy getWorkingCopy(File workingCopyRoot) {
        SvnWorkingCopy wc = this.wcPerRootDirectory.get(workingCopyRoot.toString());
        if (wc == null) {
            SVNInfo wcInfo;
            try {
                wcInfo = this.mgr.getWCClient().doInfo(workingCopyRoot, SVNRevision.WORKING);
            }
            catch (SVNException e) {
                return null;
            }
            SVNURL wcUrl = wcInfo.getURL();
            SvnRepo repo = SvnRepositoryManager.getInstance().getRepo(wcUrl);
            if (repo == null) {
                return null;
            }
            wc = new SvnWorkingCopy(repo, workingCopyRoot);
            this.wcPerRootDirectory.put(workingCopyRoot.toString(), wc);
        }
        return wc;
    }

    synchronized List<Pair<SvnWorkingCopy, SvnRepoRevision>> traverseRecentEntries(CachedLogLookupHandler handler, IChangeSourceUi ui) throws SVNException {
        ArrayList<Pair<SvnWorkingCopy, SvnRepoRevision>> revisions = new ArrayList<Pair<SvnWorkingCopy, SvnRepoRevision>>();
        for (SvnWorkingCopy wc : this.wcPerRootDirectory.values()) {
            if (ui.isCanceled()) {
                throw BackgroundJobExecutor.createOperationCanceledException();
            }
            Pair<Boolean, List<SvnRepoRevision>> getEntriesResult = SvnRepositoryManager.getInstance().traverseRecentEntries(wc.getRepository(), handler, ui);
            for (SvnRepoRevision revision : (List)getEntriesResult.getSecond()) {
                revisions.add((Pair<SvnWorkingCopy, SvnRepoRevision>)Pair.create((Object)((Object)wc), (Object)revision));
            }
            if (!((Boolean)getEntriesResult.getFirst()).booleanValue()) continue;
            this.collectWorkingCopyChanges(wc, Collections.emptyList());
        }
        return revisions;
    }

    synchronized void removeWorkingCopy(File workingCopyRoot) {
        this.wcPerRootDirectory.remove(workingCopyRoot.toString());
    }

    void collectWorkingCopyChanges(List<File> relevantPaths) throws SVNException {
        for (SvnWorkingCopy wc : SvnWorkingCopyManager.getInstance().getWorkingCopies()) {
            this.collectWorkingCopyChanges(wc, relevantPaths);
        }
    }

    private void collectWorkingCopyChanges(final SvnWorkingCopy wc, List<? extends File> relevantPaths) throws SVNException {
        final TreeMap<String, CachedLogEntryPath> changeMap = new TreeMap<String, CachedLogEntryPath>();
        ISVNStatusHandler handler = new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) throws SVNException {
                if (status.isVersioned()) {
                    CachedLogEntryPath entry = new CachedLogEntryPath(wc.getRepository(), status);
                    changeMap.put(entry.getPath(), entry);
                }
            }
        };
        if (relevantPaths != null) {
            Set<File> filteredPaths = this.filterPaths(relevantPaths, wc);
            this.collectWorkingCopyChanges(filteredPaths, handler);
        } else {
            this.collectWorkingCopyChanges(wc, handler);
        }
        SvnWorkingCopyRevision wcRevision = new SvnWorkingCopyRevision(wc, changeMap);
        FileHistoryGraph localFileHistoryGraph = new FileHistoryGraph(DiffAlgorithmFactory.createDefault());
        wcRevision.integrateInto((IMutableFileHistoryGraph)localFileHistoryGraph);
        wc.setLocalFileHistoryGraph((IMutableFileHistoryGraph)localFileHistoryGraph);
    }

    private void collectWorkingCopyChanges(Set<File> paths, ISVNStatusHandler handler) throws SVNException {
        for (File path : paths) {
            this.mgr.getStatusClient().doStatus(path, SVNRevision.WORKING, SVNDepth.EMPTY, false, false, false, false, handler, null);
        }
    }

    private void collectWorkingCopyChanges(SvnWorkingCopy wc, ISVNStatusHandler handler) throws SVNException {
        this.mgr.getStatusClient().doStatus(wc.getLocalRoot(), SVNRevision.WORKING, SVNDepth.INFINITY, false, false, false, false, handler, null);
    }

    private Set<File> filterPaths(List<? extends File> relevantPaths, SvnWorkingCopy wc) {
        LinkedHashSet<File> paths = new LinkedHashSet<File>();
        for (File file : relevantPaths) {
            String repoPath = wc.toAbsolutePathInRepo(file);
            if (repoPath == null) continue;
            paths.add(file);
        }
        for (String string : wc.getLocalFileHistoryGraph().getPaths()) {
            File path = wc.toAbsolutePathInWc(string);
            if (path == null || !path.isFile()) continue;
            paths.add(path);
        }
        return paths;
    }
}

