/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.svn;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.io.SVNRepository;

final class SvnFileCache {
    private final SVNRepository repo;
    private final Map<CachedFile, byte[]> fileContents;

    SvnFileCache(SVNRepository repo) {
        this.repo = repo;
        this.fileContents = new HashMap<CachedFile, byte[]>();
    }

    byte[] getFileContents(String path, long revision) throws SVNException {
        CachedFile entry = new CachedFile(path, revision);
        byte[] contents = this.fileContents.get(entry);
        if (contents == null) {
            contents = this.loadFile(path, revision);
            this.fileContents.put(entry, contents);
        }
        return contents;
    }

    private byte[] loadFile(String path, long revision) throws SVNException {
        ByteArrayOutputStream contents = new ByteArrayOutputStream();
        if (this.repo.checkPath(path, revision) != SVNNodeKind.FILE) {
            return new byte[0];
        }
        this.repo.getFile(path, revision, null, (OutputStream)contents);
        return contents.toByteArray();
    }

    private static final class CachedFile {
        final String path;
        final long revision;

        CachedFile(String path, long revision) {
            this.path = path;
            this.revision = revision;
        }

        public boolean equals(Object object) {
            if (object instanceof CachedFile) {
                CachedFile entry = (CachedFile)object;
                return this.path.equals(entry.path) && this.revision == entry.revision;
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode() ^ Long.valueOf(this.revision).hashCode();
        }
    }
}

