/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.svn;

import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.base.Pair;
import de.setsoftware.reviewtool.changesources.svn.CachedLogEntry;
import de.setsoftware.reviewtool.changesources.svn.CachedLogEntryPath;
import de.setsoftware.reviewtool.changesources.svn.CachedLogLookupHandler;
import de.setsoftware.reviewtool.changesources.svn.ISvnRepo;
import de.setsoftware.reviewtool.changesources.svn.SvnRepoRevision;
import de.setsoftware.reviewtool.changesources.svn.SvnRepositoryManager;
import de.setsoftware.reviewtool.changesources.svn.SvnRevision;
import de.setsoftware.reviewtool.changesources.svn.SvnWorkingCopy;
import de.setsoftware.reviewtool.changesources.svn.SvnWorkingCopyManager;
import de.setsoftware.reviewtool.model.api.BackgroundJobExecutor;
import de.setsoftware.reviewtool.model.api.ChangeSourceException;
import de.setsoftware.reviewtool.model.api.IChange;
import de.setsoftware.reviewtool.model.api.IChangeData;
import de.setsoftware.reviewtool.model.api.IChangeSource;
import de.setsoftware.reviewtool.model.api.IChangeSourceUi;
import de.setsoftware.reviewtool.model.api.ICommit;
import de.setsoftware.reviewtool.model.api.ICortProgressMonitor;
import de.setsoftware.reviewtool.model.api.IFileHistoryNode;
import de.setsoftware.reviewtool.model.api.IRevision;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.api.IWorkingCopy;
import de.setsoftware.reviewtool.model.changestructure.AbstractChangeSource;
import de.setsoftware.reviewtool.model.changestructure.ChangestructureFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;

final class SvnChangeSource
extends AbstractChangeSource {
    private final SVNClientManager mgr = SVNClientManager.newInstance();

    SvnChangeSource(String logMessagePattern, String user, String pwd, long maxTextDiffThreshold, int logCacheMinSize, File cacheDir) {
        super(logMessagePattern, maxTextDiffThreshold);
        this.mgr.setAuthenticationManager((ISVNAuthenticationManager)new DefaultSVNAuthenticationManager(null, false, user, pwd.toCharArray(), null, null));
        SvnRepositoryManager.getInstance().init(this.mgr, logCacheMinSize, cacheDir);
        SvnWorkingCopyManager.getInstance().init(this.mgr);
    }

    public File determineWorkingCopyRoot(File projectRoot) {
        File curPotentialRoot = projectRoot;
        while (!this.isPotentialRoot(curPotentialRoot)) {
            if ((curPotentialRoot = curPotentialRoot.getParentFile()) != null) continue;
            return null;
        }
        File next;
        while ((next = curPotentialRoot.getParentFile()) != null && this.isPotentialRoot(next)) {
            curPotentialRoot = next;
        }
        return curPotentialRoot;
    }

    private boolean isPotentialRoot(File next) {
        File dotsvn = new File(next, ".svn");
        return dotsvn.isDirectory();
    }

    public IChangeData getRepositoryChanges(String key, IChangeSourceUi ui) throws ChangeSourceException {
        try {
            ui.subTask("Determining relevant commits...");
            List<Pair<SvnWorkingCopy, SvnRepoRevision>> revisions = this.determineRelevantRevisions(key, ui);
            Map<ISvnRepo, Long> neededRevisionPerRepo = this.determineMaxRevisionPerRepo(revisions);
            ui.subTask("Checking state of working copy...");
            this.checkWorkingCopiesUpToDate(neededRevisionPerRepo, ui);
            ui.subTask("Analyzing commits...");
            List<ICommit> commits = this.convertRepoRevisionsToChanges(revisions, (ICortProgressMonitor)ui);
            return ChangestructureFactory.createChangeData(commits);
        }
        catch (SVNException e) {
            throw new ChangeSourceException((IChangeSource)this, (Throwable)e);
        }
    }

    public void analyzeLocalChanges(List<File> relevantPaths) throws ChangeSourceException {
        try {
            SvnWorkingCopyManager.getInstance().collectWorkingCopyChanges(relevantPaths);
        }
        catch (SVNException e) {
            throw new ChangeSourceException((IChangeSource)this, (Throwable)e);
        }
    }

    protected void workingCopyAdded(File wcRoot) {
        SvnWorkingCopyManager.getInstance().getWorkingCopy(wcRoot);
    }

    protected void workingCopyRemoved(File wcRoot) {
        SvnWorkingCopyManager.getInstance().removeWorkingCopy(wcRoot);
    }

    private void checkWorkingCopiesUpToDate(Map<ISvnRepo, Long> neededRevisionPerRepo, IChangeSourceUi ui) throws SVNException {
        for (SvnWorkingCopy wc : SvnWorkingCopyManager.getInstance().getWorkingCopies()) {
            if (ui.isCanceled()) {
                throw BackgroundJobExecutor.createOperationCanceledException();
            }
            ISvnRepo repo = wc.getRepository();
            if (!neededRevisionPerRepo.containsKey(repo)) continue;
            long remoteRev = neededRevisionPerRepo.get(repo);
            File wcRoot = wc.getLocalRoot();
            long wcRev = this.mgr.getStatusClient().doStatus(wcRoot, false).getRevision().getNumber();
            if (wcRev >= remoteRev) continue;
            Boolean doUpdate = ui.handleLocalWorkingIncomplete("The working copy (" + wc.toString() + ") does not contain all relevant changes. Perform an update?");
            if (doUpdate == null) {
                throw BackgroundJobExecutor.createOperationCanceledException();
            }
            if (!doUpdate.booleanValue()) continue;
            this.mgr.getUpdateClient().doUpdate(wcRoot, SVNRevision.HEAD, SVNDepth.INFINITY, true, false);
        }
    }

    private Map<ISvnRepo, Long> determineMaxRevisionPerRepo(List<Pair<SvnWorkingCopy, SvnRepoRevision>> revisions) {
        LinkedHashMap<ISvnRepo, Long> ret = new LinkedHashMap<ISvnRepo, Long>();
        for (Pair<SvnWorkingCopy, SvnRepoRevision> p : revisions) {
            SvnRepoRevision revision = (SvnRepoRevision)p.getSecond();
            ISvnRepo repo = revision.getRepository();
            long curRev = revision.getRevisionNumber();
            if (ret.containsKey(repo)) {
                if (curRev <= (Long)ret.get(repo)) continue;
                ret.put(repo, curRev);
                continue;
            }
            ret.put(repo, curRev);
        }
        return ret;
    }

    private List<Pair<SvnWorkingCopy, SvnRepoRevision>> determineRelevantRevisions(String key, IChangeSourceUi ui) throws SVNException {
        final Pattern pattern = this.createPatternForKey(key);
        CachedLogLookupHandler handler = new CachedLogLookupHandler(){

            @Override
            public boolean handleLogEntry(CachedLogEntry logEntry) throws SVNException {
                String message = logEntry.getMessage();
                return message != null && pattern.matcher(message).matches();
            }
        };
        return SvnWorkingCopyManager.getInstance().traverseRecentEntries(handler, ui);
    }

    private List<ICommit> convertRepoRevisionsToChanges(List<Pair<SvnWorkingCopy, SvnRepoRevision>> revisions, ICortProgressMonitor ui) {
        ArrayList<ICommit> ret = new ArrayList<ICommit>();
        for (Pair<SvnWorkingCopy, SvnRepoRevision> e : revisions) {
            if (ui.isCanceled()) {
                throw BackgroundJobExecutor.createOperationCanceledException();
            }
            this.convertToCommitIfPossible((SvnWorkingCopy)((Object)e.getFirst()), (SvnRevision)e.getSecond(), ret, ui);
        }
        return ret;
    }

    private void convertToCommitIfPossible(SvnWorkingCopy wc, SvnRevision e, Collection<? super ICommit> result, ICortProgressMonitor ui) {
        List<? extends IChange> changes = this.determineChangesInCommit(wc, e, ui);
        if (!changes.isEmpty()) {
            result.add((ICommit)ChangestructureFactory.createCommit((IWorkingCopy)wc, (String)e.toPrettyString(), changes, (IRevision)e.toRevision(), (Date)e.getDate()));
        }
    }

    private List<? extends IChange> determineChangesInCommit(SvnWorkingCopy wc, SvnRevision e, ICortProgressMonitor ui) {
        ArrayList ret = new ArrayList();
        Map<String, CachedLogEntryPath> changedPaths = e.getChangedPaths();
        DirectoryCopyInfo dirCopies = new DirectoryCopyInfo(changedPaths.values());
        Set<String> copySources = this.determineCopySources(changedPaths.values(), dirCopies);
        ArrayList<String> sortedPaths = new ArrayList<String>(changedPaths.keySet());
        Collections.sort(sortedPaths);
        for (String path : sortedPaths) {
            if (ui.isCanceled()) {
                throw BackgroundJobExecutor.createOperationCanceledException();
            }
            CachedLogEntryPath value = changedPaths.get(path);
            if (!value.isFile() || value.isDeleted() && copySources.contains(value.getPath())) continue;
            IRevisionedFile fileInfo = ChangestructureFactory.createFileInRevision((String)path, (IRevision)e.toRevision());
            IFileHistoryNode node = wc.getFileHistoryGraph().getNodeFor(fileInfo);
            if (node == null) continue;
            try {
                ret.addAll(this.determineChangesInFile((IWorkingCopy)wc, node));
            }
            catch (Exception ex) {
                Logger.error((String)("An error occurred while computing changes for " + fileInfo.toString()), (Throwable)ex);
            }
        }
        return ret;
    }

    private Set<String> determineCopySources(Collection<CachedLogEntryPath> entries, DirectoryCopyInfo dirMoves) {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        for (CachedLogEntryPath p : entries) {
            String copyPath = dirMoves.determineOldPath(p);
            if (copyPath.equals(p.getPath())) continue;
            ret.add(copyPath);
        }
        return ret;
    }

    public void clearCaches() {
        for (SvnWorkingCopy wc : SvnWorkingCopyManager.getInstance().getWorkingCopies()) {
            wc.getRepository().clearCache();
        }
    }

    private static final class DirectoryCopyInfo {
        private final List<Pair<String, String>> directoryCopies = new ArrayList<Pair<String, String>>();

        public DirectoryCopyInfo(Collection<CachedLogEntryPath> values) {
            for (CachedLogEntryPath p : values) {
                if (!p.isDir() || p.getCopyPath() == null) continue;
                this.directoryCopies.add((Pair<String, String>)Pair.create((Object)p.getCopyPath(), (Object)p.getPath()));
            }
        }

        private String determineOldPath(CachedLogEntryPath entryInfo) {
            if (entryInfo.getCopyPath() != null) {
                return entryInfo.getCopyPath();
            }
            String path = entryInfo.getPath();
            for (Pair<String, String> dirCopy : this.directoryCopies) {
                if (!path.startsWith((String)dirCopy.getSecond())) continue;
                return String.valueOf((String)dirCopy.getFirst()) + path.substring(((String)dirCopy.getSecond()).length());
            }
            return path;
        }
    }
}

