/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithRange;
import de.setsoftware.reviewtool.base.Multimap;
import de.setsoftware.reviewtool.ordering.ChangePart;
import de.setsoftware.reviewtool.ordering.HierarchyExplicitness;
import de.setsoftware.reviewtool.ordering.JavaParserBasedRelation;
import de.setsoftware.reviewtool.ordering.LineRangeMap;
import de.setsoftware.reviewtool.ordering.MethodKey;

public class MethodOverrideRelation
extends JavaParserBasedRelation {
    public MethodOverrideRelation(HierarchyExplicitness explicitness) {
        super(explicitness);
    }

    @Override
    protected void handleType(Multimap<MethodKey, ChangePart> centerCandidates, Multimap<MethodKey, ChangePart> rayCandidates, LineRangeMap lineRanges, TypeDeclaration<?> t) {
        for (BodyDeclaration d : t.getMembers()) {
            if (d instanceof MethodDeclaration) {
                MethodDeclaration m = (MethodDeclaration)d;
                if (MethodOverrideRelation.canBeRay(m, t)) {
                    rayCandidates.putAll((Object)new MethodKey(m), lineRanges.getOverlappingParts((NodeWithRange<?>)m));
                    continue;
                }
                if (!MethodOverrideRelation.canBeCenter(m, t)) continue;
                centerCandidates.putAll((Object)new MethodKey(m), lineRanges.getOverlappingParts((NodeWithRange<?>)m));
                continue;
            }
            if (!(d instanceof TypeDeclaration)) continue;
            this.handleType(centerCandidates, rayCandidates, lineRanges, (TypeDeclaration)d);
        }
    }

    private static boolean canBeCenter(MethodDeclaration m, TypeDeclaration<?> t) {
        return !m.isPrivate() && !m.isFinal() && !m.isStatic() && !MethodOverrideRelation.isFinal(t);
    }

    private static boolean isFinal(TypeDeclaration<?> t) {
        for (Modifier m : t.getModifiers()) {
            if (!m.equals((Object)Modifier.finalModifier())) continue;
            return true;
        }
        return false;
    }

    private static boolean canBeRay(MethodDeclaration m, TypeDeclaration<?> t) {
        return MethodOverrideRelation.hasOverride(m);
    }

    private static boolean hasOverride(MethodDeclaration m) {
        for (AnnotationExpr a : m.getAnnotations()) {
            if (!a.getNameAsString().equals("Override")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String toRelationKey(MethodKey key) {
        return String.valueOf(key.toString()) + " hierarchy";
    }
}

