/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering;

import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.MethodCallExpr;

class MethodKey {
    private final String name;
    private final int argCount;

    public MethodKey(MethodDeclaration m) {
        this.name = m.getNameAsString();
        this.argCount = m.getParameters().size();
    }

    public MethodKey(MethodCallExpr c) {
        this.name = c.getNameAsString();
        this.argCount = c.getArguments().size();
    }

    public int hashCode() {
        return this.name.hashCode() + this.argCount;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodKey)) {
            return false;
        }
        MethodKey k = (MethodKey)o;
        return this.name.equals(k.name) && this.argCount == k.argCount;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.name);
        ret.append('(');
        if (this.argCount > 0) {
            ret.append('_');
        }
        int i = 1;
        while (i < this.argCount) {
            ret.append(",_");
            ++i;
        }
        ret.append(')');
        return ret.toString();
    }
}

