/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.irrelevancestrategies.pathfilters;

import de.setsoftware.reviewtool.model.api.IChange;
import de.setsoftware.reviewtool.model.api.ICommit;
import de.setsoftware.reviewtool.model.changestructure.IIrrelevanceDetermination;
import java.util.regex.Pattern;

public class PathFilter
extends IIrrelevanceDetermination {
    private final String description;
    private final Pattern pattern;

    public PathFilter(int number, String pattern, String description) {
        super(number);
        this.pattern = PathFilter.convertAntToRegex(pattern);
        this.description = description;
    }

    private static Pattern convertAntToRegex(String antStylePattern) {
        StringBuilder part = new StringBuilder();
        StringBuilder regex = new StringBuilder();
        char[] cArray = antStylePattern.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (ch == '/' || ch == '\\') {
                if (part.toString().equals("*")) {
                    regex.append("[^\\\\/]*");
                    part.setLength(0);
                } else {
                    regex.append(Pattern.quote(part.toString()));
                    part.setLength(0);
                }
                regex.append("(^|[\\\\/])");
            } else if (ch == '*') {
                if (part.toString().equals("*")) {
                    regex.append(".*");
                    part.setLength(0);
                } else {
                    regex.append(Pattern.quote(part.toString()));
                    part.setLength(0);
                    part.append(ch);
                }
            } else {
                if (part.toString().equals("*")) {
                    regex.append("[^\\\\/]*");
                    part.setLength(0);
                }
                part.append(ch);
            }
            ++n2;
        }
        if (part.toString().equals("*")) {
            regex.append(".*");
            part.setLength(0);
        } else {
            regex.append(Pattern.quote(part.toString()));
            part.setLength(0);
        }
        return Pattern.compile(regex.toString());
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isIrrelevant(ICommit commit, IChange change) {
        return this.pattern.matcher(change.getFrom().getPath()).matches() && this.pattern.matcher(change.getTo().getPath()).matches();
    }
}

