/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.Multimap;
import de.setsoftware.reviewtool.base.PartialOrderAlgorithms;
import de.setsoftware.reviewtool.model.api.IDiffAlgorithm;
import de.setsoftware.reviewtool.model.api.IFileHistoryGraph;
import de.setsoftware.reviewtool.model.api.IFileHistoryNode;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.changestructure.AbstractFileHistoryGraph;
import de.setsoftware.reviewtool.model.changestructure.VirtualFileHistoryNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class VirtualFileHistoryGraph
extends AbstractFileHistoryGraph {
    private final IFileHistoryGraph remoteFileHistoryGraph;
    private IFileHistoryGraph localFileHistoryGraph;
    private final Map<IRevisionedFile, IFileHistoryNode> virtualNodes;

    public VirtualFileHistoryGraph(IFileHistoryGraph remoteFileHistoryGraph) {
        this.remoteFileHistoryGraph = remoteFileHistoryGraph;
        this.localFileHistoryGraph = null;
        this.virtualNodes = new LinkedHashMap<IRevisionedFile, IFileHistoryNode>();
    }

    public synchronized IFileHistoryGraph getLocalFileHistoryGraph() {
        return this.localFileHistoryGraph;
    }

    public synchronized void setLocalFileHistoryGraph(IFileHistoryGraph localFileHistoryGraph) {
        this.localFileHistoryGraph = localFileHistoryGraph;
        this.virtualNodes.clear();
        if (this.localFileHistoryGraph != null) {
            this.computeIntermediateNodes();
        }
    }

    public IFileHistoryGraph getRemoteFileHistoryGraph() {
        return this.remoteFileHistoryGraph;
    }

    private void computeIntermediateNodes() {
        for (IFileHistoryNode localNode : this.localFileHistoryGraph.getIncompleteFlowStarts()) {
            this.computeIntermediateNodes(localNode);
        }
    }

    private void computeIntermediateNodes(IFileHistoryNode localNode) {
        IFileHistoryNode remoteNode = this.remoteFileHistoryGraph.getNodeFor(localNode.getFile());
        if (remoteNode != null) {
            VirtualFileHistoryNode virtualNode = new VirtualFileHistoryNode(this, localNode.getFile(), Arrays.asList(remoteNode, localNode));
            this.virtualNodes.put(virtualNode.getFile(), virtualNode);
            return;
        }
        Set<? extends IFileHistoryNode> remoteNodes = this.remoteFileHistoryGraph.findAncestorsFor(localNode.getFile());
        if (!remoteNodes.isEmpty()) {
            for (IFileHistoryNode iFileHistoryNode : remoteNodes) {
                VirtualFileHistoryNode virtualAncestorNode = new VirtualFileHistoryNode(this, iFileHistoryNode.getFile(), Collections.singletonList(iFileHistoryNode));
                VirtualFileHistoryNode virtualDescendantNode = new VirtualFileHistoryNode(this, localNode.getFile(), Collections.singletonList(localNode));
                virtualAncestorNode.addDescendant(virtualDescendantNode);
                virtualDescendantNode.addAncestor(virtualAncestorNode);
                this.virtualNodes.put(virtualAncestorNode.getFile(), virtualAncestorNode);
                this.virtualNodes.put(virtualDescendantNode.getFile(), virtualDescendantNode);
            }
        }
    }

    @Override
    public synchronized Set<String> getPaths() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(this.remoteFileHistoryGraph.getPaths());
        result.addAll(this.localFileHistoryGraph.getPaths());
        return result;
    }

    @Override
    public synchronized IFileHistoryNode getNodeFor(IRevisionedFile file) {
        IFileHistoryNode localNode;
        IFileHistoryNode virtualNode = this.virtualNodes.get(file);
        if (virtualNode != null) {
            return virtualNode;
        }
        ArrayList<IFileHistoryNode> nodes = new ArrayList<IFileHistoryNode>();
        IFileHistoryNode remoteNode = this.remoteFileHistoryGraph.getNodeFor(file);
        if (remoteNode != null) {
            nodes.add(remoteNode);
        }
        IFileHistoryNode iFileHistoryNode = localNode = this.localFileHistoryGraph != null ? this.localFileHistoryGraph.getNodeFor(file) : null;
        if (localNode != null) {
            nodes.add(localNode);
        }
        if (!nodes.isEmpty()) {
            VirtualFileHistoryNode node = new VirtualFileHistoryNode(this, file, nodes);
            return node;
        }
        return null;
    }

    public synchronized Set<VirtualFileHistoryNode> findAncestorsFor(IRevisionedFile file) {
        Multimap<IRevisionedFile, IFileHistoryNode> nodeMap = new Multimap<IRevisionedFile, IFileHistoryNode>();
        Set<? extends IFileHistoryNode> remoteAncestors = this.remoteFileHistoryGraph.findAncestorsFor(file);
        for (IFileHistoryNode iFileHistoryNode : remoteAncestors) {
            nodeMap.put(iFileHistoryNode.getFile(), iFileHistoryNode);
        }
        Set<? extends IFileHistoryNode> set = this.localFileHistoryGraph.findAncestorsFor(file);
        for (IFileHistoryNode iFileHistoryNode : set) {
            nodeMap.put(iFileHistoryNode.getFile(), iFileHistoryNode);
        }
        if (!nodeMap.isEmpty()) {
            List list = PartialOrderAlgorithms.topoSort(nodeMap.keySet());
            List<IRevisionedFile> maximalFiles = PartialOrderAlgorithms.getAllMaximalElements(list);
            LinkedHashSet<VirtualFileHistoryNode> ancestors = new LinkedHashSet<VirtualFileHistoryNode>();
            for (IRevisionedFile ancestorFile : maximalFiles) {
                List<IFileHistoryNode> nodes = nodeMap.get(ancestorFile);
                ancestors.add(new VirtualFileHistoryNode(this, file, nodes));
            }
            return ancestors;
        }
        return new LinkedHashSet<VirtualFileHistoryNode>();
    }

    @Override
    public final synchronized Set<IFileHistoryNode> getIncompleteFlowStarts() {
        LinkedHashSet<IFileHistoryNode> result = new LinkedHashSet<IFileHistoryNode>();
        result.addAll(this.remoteFileHistoryGraph.getIncompleteFlowStarts());
        result.addAll(this.localFileHistoryGraph.getIncompleteFlowStarts());
        return result;
    }

    @Override
    public IDiffAlgorithm getDiffAlgorithm() {
        return this.remoteFileHistoryGraph.getDiffAlgorithm();
    }
}

