/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.model.api.IFileDiff;
import de.setsoftware.reviewtool.model.api.IFileHistoryEdge;
import de.setsoftware.reviewtool.model.api.IFileHistoryNode;
import de.setsoftware.reviewtool.model.changestructure.AbstractFileHistoryEdge;
import de.setsoftware.reviewtool.model.changestructure.VirtualFileHistoryGraph;

final class VirtualFileHistoryEdge
extends AbstractFileHistoryEdge {
    private final VirtualFileHistoryGraph graph;
    private final IFileHistoryNode ancestor;
    private final IFileHistoryNode descendant;
    private final IFileHistoryEdge.Type type;
    private final IFileDiff diff;

    public VirtualFileHistoryEdge(VirtualFileHistoryGraph graph, IFileHistoryNode ancestor, IFileHistoryNode descendant, IFileHistoryEdge.Type type, IFileDiff diff) {
        this.graph = graph;
        this.ancestor = ancestor;
        this.descendant = descendant;
        this.type = type;
        this.diff = diff;
    }

    @Override
    public VirtualFileHistoryGraph getGraph() {
        return this.graph;
    }

    @Override
    public IFileHistoryNode getAncestor() {
        return this.ancestor;
    }

    @Override
    public IFileHistoryNode getDescendant() {
        return this.descendant;
    }

    @Override
    public IFileHistoryEdge.Type getType() {
        return this.type;
    }

    @Override
    public IFileDiff getDiff() {
        return this.diff;
    }

    public boolean equals(Object o) {
        if (o instanceof VirtualFileHistoryEdge) {
            VirtualFileHistoryEdge other = (VirtualFileHistoryEdge)o;
            return this.ancestor.equals(other.getAncestor()) && this.descendant.equals(other.getDescendant());
        }
        return false;
    }

    public int hashCode() {
        return this.ancestor.hashCode() ^ this.descendant.hashCode();
    }
}

