/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.model.api.IDelta;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.IFragmentList;
import de.setsoftware.reviewtool.model.api.IHunk;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.api.ITextualChange;
import de.setsoftware.reviewtool.model.api.IncompatibleFragmentException;
import de.setsoftware.reviewtool.model.changestructure.FragmentList;
import java.util.Collection;

public final class Hunk
implements IHunk {
    private static final long serialVersionUID = 6069703227726679411L;
    private final IFragment source;
    private final IFragment target;
    private final IDelta delta;

    public Hunk(IFragment source, IFragment target) {
        this.source = source;
        this.target = target;
        this.delta = this.target.getSize().minus(this.source.getSize());
    }

    public Hunk(ITextualChange hunk) {
        this(hunk.getFromFragment(), hunk.getToFragment());
    }

    @Override
    public IFragment getSource() {
        return this.source;
    }

    @Override
    public IFragment getTarget() {
        return this.target;
    }

    @Override
    public IDelta getDelta() {
        return this.delta;
    }

    @Override
    public boolean isInline() {
        return this.source.isInline();
    }

    public static IFragmentList getSources(Collection<? extends IHunk> hunks) {
        FragmentList result = new FragmentList();
        for (IHunk iHunk : hunks) {
            try {
                result.addFragment(iHunk.getSource());
            }
            catch (IncompatibleFragmentException e) {
                throw new ReviewtoolException(e);
            }
        }
        result.coalesce();
        return result;
    }

    public static IFragmentList getTargets(Collection<? extends IHunk> hunks) {
        FragmentList result = new FragmentList();
        for (IHunk iHunk : hunks) {
            try {
                result.addFragment(iHunk.getTarget());
            }
            catch (IncompatibleFragmentException e) {
                throw new ReviewtoolException(e);
            }
        }
        result.coalesce();
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof Hunk) {
            IHunk hunk = (IHunk)other;
            return this.getClass() == other.getClass() && this.source.equals(hunk.getSource()) && this.target.equals(hunk.getTarget());
        }
        return false;
    }

    public int hashCode() {
        return this.source.hashCode() ^ this.target.hashCode();
    }

    public String toString() {
        return "Hunk: " + this.source + "(" + this.source.getContentFullLines() + ") --> " + this.target + "(" + this.target.getContentFullLines() + ")";
    }

    @Override
    public IHunk adjustSource(IDelta delta) {
        return new Hunk(this.getSource().adjust(delta), this.getTarget());
    }

    @Override
    public IHunk adjustTarget(IDelta delta) {
        return new Hunk(this.getSource(), this.getTarget().adjust(delta));
    }

    @Override
    public IHunk adjustSourceFile(IRevisionedFile source) {
        return new Hunk(this.source.setFile(source), this.target);
    }

    @Override
    public IHunk adjustTargetFile(IRevisionedFile target) {
        return new Hunk(this.source, this.target.setFile(target));
    }

    @Override
    public int compareTo(IHunk o) {
        return this.source.compareTo(o.getSource());
    }
}

